/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jlab.coda.cMsg.cMsg;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.cMsg.cMsgMessage;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;

public class cMsgEventSerialize {
    private String subject = "evio";
    private String type = "anything";
    private String name = "producer";
    private String description = "java event producer";
    private String UDL = "cMsg://localhost/cMsg/myNameSpace";

    cMsgEventSerialize(String[] args) {
        this.decodeCommandLine(args);
    }

    private void decodeCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-h")) {
                cMsgEventSerialize.usage();
                System.exit(-1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.name = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                this.description = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-u")) {
                this.UDL = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-s")) {
                this.subject = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-t")) {
                this.type = args[i + 1];
                ++i;
                continue;
            }
            cMsgEventSerialize.usage();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:\n\n   java cMsgProducer\n        [-n <name>]          set client name\n        [-d <description>]   set description of client\n        [-u <UDL>]           set UDL to connect to cMsg\n        [-s <subject>]       set subject of sent messages\n        [-t <type>]          set type of sent messages\n        [-h]                 print this help\n");
    }

    public static void main(String[] args) {
        try {
            cMsgEventSerialize producer = new cMsgEventSerialize(args);
            producer.run();
        }
        catch (cMsgException e) {
            System.out.println(e.toString());
            System.exit(-1);
        }
    }

    public void run() throws cMsgException {
        System.out.println("Running cMsg producer sending to:\n    subject = " + this.subject + "\n    type    = " + this.type + "\n    UDL     = " + this.UDL);
        cMsg coda = new cMsg(this.UDL, this.name, this.description);
        try {
            coda.connect();
        }
        catch (cMsgException e) {
            e.printStackTrace();
            return;
        }
        cMsgMessage msg = new cMsgMessage();
        msg.setSubject(this.subject);
        msg.setType(this.type);
        ByteBuffer myBuf = ByteBuffer.allocate(10000);
        String dictionary = "<xmlDict>\n  <xmldumpDictEntry name=\"bank\"  tag=\"1\"   num=\"1\"/>\n</xmlDict>";
        int[] data = new int[]{1, 2, 3, 4};
        try {
            int maxBanksPerBlock = 100;
            int maxBlockSizeInBytes = 1000000;
            EventWriter eventWriter = new EventWriter(myBuf, maxBlockSizeInBytes, maxBanksPerBlock, dictionary, null);
            EventBuilder eventBuilder = new EventBuilder(1, DataType.INT32, 1);
            EvioEvent ev = eventBuilder.getEvent();
            ev.appendIntData(data);
            eventWriter.writeEvent(ev);
            eventWriter.close();
            myBuf.flip();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        msg.setByteArray(myBuf.array(), 0, myBuf.limit());
        coda.send(msg);
    }
}

