/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.CompositeData;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;

public class SwapTest {
    static byte[] byteData = new byte[]{1, 2, 3};
    static short[] shortData = new short[]{1, 2, 3};
    static int[] intData = new int[]{1, 2, 3};
    static long[] longData = new long[]{1L, 2L, 3L};
    static float[] floatData = new float[]{1.0f, 2.0f, 3.0f};
    static double[] doubleData = new double[]{1.0, 2.0, 3.0};
    static String[] stringData = new String[]{"123", "456", "789"};
    static ByteBuffer firstBlockHeader = ByteBuffer.allocate(32);
    static ByteBuffer emptyLastHeader = ByteBuffer.allocate(32);

    private static void printDoubleBuffer(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        System.out.println();
        for (int i = 0; i < byteBuffer.limit() / 8; ++i) {
            System.out.print(byteBuffer.getDouble() + " ");
            if ((i + 1) % 8 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private static void printIntBuffer(ByteBuffer byteBuffer) {
        byteBuffer.flip();
        System.out.println();
        for (int i = 0; i < byteBuffer.limit() / 4; ++i) {
            System.out.print(byteBuffer.getInt() + " ");
            if ((i + 1) % 16 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private static void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    static void setFirstBlockHeader(int words, int count) {
        firstBlockHeader.putInt(0, words + 8);
        firstBlockHeader.putInt(4, 1);
        firstBlockHeader.putInt(8, 8);
        firstBlockHeader.putInt(12, count);
        firstBlockHeader.putInt(16, 0);
        firstBlockHeader.putInt(20, 4);
        firstBlockHeader.putInt(24, 0);
        firstBlockHeader.putInt(28, -1059454720);
    }

    static EvioEvent createSingleEvent(int tag) {
        EvioEvent event = null;
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankBanks = new EvioBank(tag + 1, DataType.BANK, 2);
            builder.addChild(event, bankBanks);
            EvioBank bankInts = new EvioBank(tag + 2, DataType.INT32, 3);
            bankInts.appendIntData(intData);
            builder.addChild(bankBanks, bankInts);
            EvioBank bankBanks2 = new EvioBank(tag + 3, DataType.SEGMENT, 4);
            builder.addChild(event, bankBanks2);
            EvioSegment bankShorts = new EvioSegment(tag + 4, DataType.SHORT16);
            bankShorts.appendShortData(shortData);
            builder.addChild(bankBanks2, bankShorts);
            EvioSegment bankBanks3 = new EvioSegment(tag + 5, DataType.SEGMENT);
            builder.addChild(bankBanks2, bankBanks3);
            EvioSegment bankDoubles = new EvioSegment(tag + 6, DataType.DOUBLE64);
            bankDoubles.appendDoubleData(doubleData);
            builder.addChild(bankBanks3, bankDoubles);
            EvioBank bankBanks4 = new EvioBank(tag + 7, DataType.TAGSEGMENT, 8);
            builder.addChild(event, bankBanks4);
            EvioTagSegment bankBytes = new EvioTagSegment(tag + 8, DataType.CHAR8);
            bankBytes.appendByteData(byteData);
            builder.addChild(bankBanks4, bankBytes);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static EvioEvent createSimpleEvent(int tag) {
        EvioEvent event = null;
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankDoubles = new EvioBank(tag + 6, DataType.DOUBLE64, 7);
            bankDoubles.appendDoubleData(doubleData);
            builder.addChild(event, bankDoubles);
            CompositeData.Data cData = new CompositeData.Data();
            cData.addShort((short)1);
            cData.addInt(1);
            cData.addLong(1L);
            cData.addFloat(1.0f);
            cData.addDouble(1.0);
            cData.addShort((short)2);
            cData.addInt(2);
            cData.addLong(2L);
            cData.addFloat(2.0f);
            cData.addDouble(2.0);
            CompositeData cd = new CompositeData("S,I,L,F,D", 1, cData, 2, 3);
            System.out.println("CD:\n" + cd.toString());
            EvioBank bankComposite = new EvioBank(tag + 8, DataType.COMPOSITE, 9);
            bankComposite.appendCompositeData(new CompositeData[]{cd});
            builder.addChild(event, bankComposite);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    public static void main(String[] args) {
        try {
            EvioEvent bank = SwapTest.createSingleEvent(1);
            int byteSize = bank.getTotalBytes();
            ByteBuffer bb1 = ByteBuffer.allocate(2 * byteSize + 64);
            ByteBuffer bb2 = ByteBuffer.allocate(2 * byteSize + 64);
            SwapTest.setFirstBlockHeader(2 * byteSize / 4, 2);
            bb1.put(firstBlockHeader);
            firstBlockHeader.position(0);
            bank.write(bb1);
            bank.write(bb1);
            bb1.put(emptyLastHeader);
            emptyLastHeader.position(0);
            bb1.flip();
            bb2.put(bb1);
            bb1.flip();
            bb2.flip();
            System.out.println("XML:\n" + bank.toXML());
            LinkedList<EvioNode> list = new LinkedList<EvioNode>();
            ByteDataTransformer.swapEvent(bb1, bb2, 32, 32);
            System.out.println("\n*************\n");
            ByteDataTransformer.swapEvent(bb2, bb2, 32, 32, list);
            System.out.println("Node list size = " + list.size());
            EvioReader reader = new EvioReader(bb2);
            EvioEvent ev = reader.parseEvent(1);
            System.out.println("\n\n reconstituted XML:\n" + ev.toXML());
            IntBuffer ibuf1 = bb1.asIntBuffer();
            IntBuffer ibuf2 = bb2.asIntBuffer();
            int lenInInts = ibuf1.limit() < ibuf1.capacity() ? ibuf1.limit() : ibuf1.capacity();
            System.out.println("ibuf1 limit = " + ibuf1.limit() + ", cap = " + ibuf1.capacity());
            System.out.println("ibuf2 limit = " + ibuf2.limit() + ", cap = " + ibuf2.capacity());
            System.out.println("bb1           bb2\n---------------------------");
            for (int i = 0; i < lenInInts; ++i) {
                if (ibuf1.get(i) == ibuf2.get(i)) continue;
                System.out.println("index " + i + ": 0x" + Integer.toHexString(ibuf1.get(i)) + " swapped to 0x" + Integer.toHexString(ibuf1.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        emptyLastHeader.putInt(0, 8);
        emptyLastHeader.putInt(4, 2);
        emptyLastHeader.putInt(8, 8);
        emptyLastHeader.putInt(12, 0);
        emptyLastHeader.putInt(16, 0);
        emptyLastHeader.putInt(20, 516);
        emptyLastHeader.putInt(24, 0);
        emptyLastHeader.putInt(28, -1059454720);
    }
}

