/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.test;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventBuilder;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioCompactReader;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioNode;
import org.jlab.coda.jevio.EvioSegment;
import org.jlab.coda.jevio.EvioTagSegment;
import org.jlab.coda.jevio.EvioXMLDictionary;

public class CompactReaderTest {
    private static void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    static EvioEvent createSingleEvent(int tag) {
        EvioEvent event = null;
        int[] intData = new int[2];
        Arrays.fill(intData, 1);
        byte[] byteData = new byte[9];
        Arrays.fill(byteData, (byte)2);
        short[] shortData = new short[3];
        Arrays.fill(shortData, (short)3);
        double[] doubleData = new double[1];
        Arrays.fill(doubleData, 4.0);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankBanks = new EvioBank(tag + 1, DataType.BANK, 2);
            builder.addChild(event, bankBanks);
            EvioBank bankInts = new EvioBank(tag + 2, DataType.INT32, 3);
            bankInts.appendIntData(intData);
            builder.addChild(bankBanks, bankInts);
            EvioBank bankBanks2 = new EvioBank(tag + 3, DataType.BANK, 4);
            builder.addChild(event, bankBanks2);
            EvioBank bankShorts = new EvioBank(tag + 4, DataType.SHORT16, 5);
            bankShorts.appendShortData(shortData);
            builder.addChild(bankBanks2, bankShorts);
            EvioBank bankBanks3 = new EvioBank(tag + 5, DataType.BANK, 6);
            builder.addChild(bankBanks2, bankBanks3);
            EvioBank bankDoubles = new EvioBank(tag + 6, DataType.DOUBLE64, 7);
            bankDoubles.appendDoubleData(doubleData);
            builder.addChild(bankBanks3, bankDoubles);
            EvioBank bankBanks4 = new EvioBank(tag + 7, DataType.BANK, 8);
            builder.addChild(event, bankBanks4);
            EvioBank bankBytes = new EvioBank(tag + 8, DataType.CHAR8, 9);
            bankBytes.appendByteData(byteData);
            builder.addChild(bankBanks4, bankBytes);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static EvioEvent createSimpleSingleEvent(int tag) {
        EvioEvent event = null;
        int[] intData = new int[21];
        Arrays.fill(intData, 1);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankInts = new EvioBank(tag + 1, DataType.INT32, 2);
            bankInts.appendIntData(intData);
            builder.addChild(event, bankInts);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static EvioEvent createSingleEvent1(int tag) {
        EvioEvent event = null;
        int[] intData = new int[4];
        Arrays.fill(intData, 1);
        byte[] byteData = new byte[4];
        Arrays.fill(byteData, (byte)2);
        short[] shortData = new short[4];
        Arrays.fill(shortData, (short)3);
        double[] doubleData = new double[5];
        Arrays.fill(doubleData, 4.0);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.BANK, 1);
            event = builder.getEvent();
            EvioBank bankBanks = new EvioBank(tag + 1, DataType.BANK, 2);
            builder.addChild(event, bankBanks);
            EvioBank bankInts = new EvioBank(tag + 2, DataType.INT32, 3);
            bankInts.appendIntData(intData);
            builder.addChild(bankBanks, bankInts);
            EvioBank bankSegs = new EvioBank(tag + 3, DataType.SEGMENT, 1);
            builder.addChild(event, bankSegs);
            EvioSegment segShorts = new EvioSegment(tag + 4, DataType.SHORT16);
            segShorts.appendShortData(shortData);
            builder.addChild(bankSegs, segShorts);
            EvioSegment segSegs = new EvioSegment(tag + 5, DataType.SEGMENT);
            builder.addChild(bankSegs, segSegs);
            EvioSegment segDoubles = new EvioSegment(tag + 6, DataType.DOUBLE64);
            segDoubles.appendDoubleData(doubleData);
            builder.addChild(segSegs, segDoubles);
            EvioBank bankTagsegs = new EvioBank(tag + 7, DataType.TAGSEGMENT, 1);
            builder.addChild(event, bankTagsegs);
            EvioTagSegment tagBytes = new EvioTagSegment(tag + 8, DataType.CHAR8);
            tagBytes.appendByteData(byteData);
            builder.addChild(bankTagsegs, tagBytes);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static EvioEvent createSingleEvent2(int tag) {
        EvioEvent event = null;
        int[] intData = new int[1];
        Arrays.fill(intData, 1);
        byte[] byteData = new byte[4];
        Arrays.fill(byteData, (byte)2);
        short[] shortData = new short[2];
        Arrays.fill(shortData, (short)3);
        double[] doubleData = new double[1];
        Arrays.fill(doubleData, 4.0);
        try {
            EventBuilder builder = new EventBuilder(tag, DataType.SEGMENT, 1);
            event = builder.getEvent();
            EvioSegment segShorts = new EvioSegment(tag + 4, DataType.SHORT16);
            segShorts.appendShortData(shortData);
            builder.addChild(event, segShorts);
            EvioSegment segDoubles = new EvioSegment(tag + 6, DataType.DOUBLE64);
            segDoubles.appendDoubleData(doubleData);
            builder.addChild(event, segDoubles);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        return event;
    }

    static ByteBuffer createSingleSegment(int tag) {
        EvioSegment seg = new EvioSegment(tag, DataType.INT32);
        int[] intData = new int[10];
        Arrays.fill(intData, 456);
        try {
            seg.appendIntData(intData);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(48);
        seg.write(bb);
        bb.flip();
        return bb;
    }

    static ByteBuffer createSingleBank(int tag, int num) {
        EvioEvent bank = CompactReaderTest.createSingleEvent1(tag);
        int byteSize = bank.getTotalBytes();
        ByteBuffer bb = ByteBuffer.allocate(byteSize);
        bank.write(bb);
        bb.flip();
        return bb;
    }

    static ByteBuffer createSingleBank2(int tag, int num) {
        EvioBank bank = new EvioBank(tag, DataType.INT32, num);
        int[] intData = new int[10];
        Arrays.fill(intData, 123);
        try {
            bank.appendIntData(intData);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        ByteBuffer bb = ByteBuffer.allocate(48);
        bank.write(bb);
        bb.flip();
        return bb;
    }

    static ByteBuffer createBuffer(int eventCount) {
        String xmlDict = null;
        String xmlDict2 = "<xmlDict attr='junk'><dictEntry name='T7N0'    tag= '7'    num = '0' /><dictEntry name='T3N3'    tag= '3'    num = '3' /><dictEntry name='T66N99'  tag= '66'   num = '99' /></xmlDict>";
        ByteBuffer myBuf = ByteBuffer.allocate(1000 * eventCount);
        try {
            EventWriter writer = new EventWriter(myBuf, 10000, 100, xmlDict, null);
            EvioEvent ev = CompactReaderTest.createSimpleSingleEvent(1);
            for (int i = 0; i < eventCount; ++i) {
                writer.writeEvent(ev);
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        myBuf.flip();
        return myBuf;
    }

    static void printBytes(ByteBuffer buf) {
        for (int i = buf.position(); i < buf.capacity(); ++i) {
            System.out.println("byte = " + buf.get(i));
        }
        System.out.println("\n");
    }

    public static void main5(String[] args) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(0, 666);
        CompactReaderTest.printBytes(buf);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int readVal = buf.getInt(0);
        System.out.println("read value = " + readVal);
        CompactReaderTest.printBytes(buf);
    }

    public static void main(String[] args) {
        try {
            EvioCompactReader reader = new EvioCompactReader("/daqfs/home/timmer/coda/jevio-4.1/testdata/BSTN2.ev");
            int evCount = reader.getEventCount();
            Scanner keyboard = new Scanner(System.in);
            keyboard.next().charAt(0);
            for (int i = 0; i < evCount; ++i) {
                Thread.sleep(1L);
                reader.searchEvent(i + 1, 10, 1);
            }
            reader.close();
        }
        catch (EvioException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main1(String[] args) {
        int count = 5;
        ByteBuffer myBuf = CompactReaderTest.createBuffer(count);
        System.out.println("created buffer, pos = " + myBuf.position() + ", lim = " + myBuf.limit());
        ByteBuffer addBankBuf = CompactReaderTest.createSingleBank(66, 99);
        System.out.println("addBankBuf size = " + addBankBuf.remaining());
        try {
            EvioCompactReader reader = new EvioCompactReader(myBuf);
            EvioNode node = reader.getEvent(4);
            System.out.println("event 4 pos = " + node.getPosition());
            int evCount = reader.getEventCount();
            List<EvioNode> returnList = reader.searchEvent(4, 7, 7);
            if (returnList.size() < 1) {
                System.out.println("GOT NOTHING IN SEARCH for ev 4, T/N = 7/7");
            } else {
                System.out.println("Found " + returnList.size() + " banks for ev 4, T/N = 7/7");
            }
            returnList = reader.searchEvent(2, 7, 7);
            if (returnList.size() < 1) {
                System.out.println("GOT NOTHING IN SEARCH for ev 2, T/N = 7/7");
            } else {
                System.out.println("Found " + returnList.size() + " banks for ev 2, T/N = 7/7");
            }
            System.out.println("Insert buffer of " + addBankBuf.remaining() + " bytes");
            reader.addStructure(2, addBankBuf);
            System.out.println("Insert another buffer of " + addBankBuf.remaining() + " bytes");
            reader.addStructure(2, addBankBuf);
            System.out.println("event 4 again, pos = " + node.getPosition());
            returnList = reader.searchEvent(4, 7, 7);
            if (returnList.size() < 1) {
                System.out.println("GOT NOTHING IN SEARCH for ev4, T/N = 7/7");
            } else {
                System.out.println("Data for T/n = 7/7 ->");
                EvioNode node70 = returnList.get(0);
                ByteBuffer buf = reader.getData(node70);
                DataType dType = node70.getDataTypeObj();
                System.out.println("Get data of type " + (Object)((Object)dType));
                if (dType == DataType.DOUBLE64) {
                    System.out.println("Double data =");
                    DoubleBuffer dbuf = buf.asDoubleBuffer();
                    for (int k = 0; k < dbuf.limit(); ++k) {
                        System.out.println(k + "   " + dbuf.get(k));
                    }
                }
            }
        }
        catch (EvioException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main2(String[] args) {
        int count = 5;
        int evCount = 0;
        int loops = 100000;
        ByteBuffer myBuf = CompactReaderTest.createBuffer(count);
        System.out.println("created buffer, pos = " + myBuf.position() + ", lim = " + myBuf.limit());
        ByteBuffer bankBuf = CompactReaderTest.createSingleBank(66, 99);
        try {
            long t1 = System.currentTimeMillis();
            t1 = System.currentTimeMillis();
            for (int i = 0; i < 1; ++i) {
                try {
                    EvioXMLDictionary dictionary;
                    String xmlDict;
                    EvioCompactReader reader = new EvioCompactReader(myBuf);
                    if (reader.hasDictionary()) {
                        System.out.println(" *** We Have a dictionary ***");
                    }
                    if ((xmlDict = reader.getDictionaryXML()) != null) {
                        System.out.println("HEY WE GOTTA DICTIONARY String = \n" + xmlDict);
                    }
                    if ((dictionary = reader.getDictionary()) != null) {
                        System.out.println("HEY WE GOTTA DICTIONARY OBJECT !!!");
                    }
                    evCount = reader.getEventCount();
                    for (int j = 0; j < 1; ++j) {
                        EvioNode node33;
                        int k;
                        Buffer ibuf;
                        DataType dType;
                        ByteBuffer buf;
                        EvioNode node70;
                        reader.addStructure(1, bankBuf);
                        List<EvioNode> returnList = reader.searchEvent(1, 66, 99);
                        if (returnList.size() < 1) {
                            System.out.println("GOT NOTHING IN SEARCH for T66N99");
                        } else {
                            node70 = returnList.get(0);
                            System.out.println("Data for T66N99 (ret list = " + returnList.size() + ") ->");
                            buf = reader.getData(node70);
                            dType = node70.getDataTypeObj();
                            System.out.println("Get data of type " + (Object)((Object)dType));
                            if (dType == DataType.INT32) {
                                System.out.println("Int data =");
                                ibuf = buf.asIntBuffer();
                                for (k = 0; k < ibuf.limit(); ++k) {
                                    System.out.println(k + "   " + ((IntBuffer)ibuf).get(k));
                                }
                            }
                        }
                        returnList = reader.searchEvent(3, 7, 0);
                        if (returnList.size() < 1) {
                            System.out.println("GOT NOTHING IN SEARCH for T7N0");
                        } else {
                            System.out.println("Data for T7N0 ->");
                            node70 = returnList.get(0);
                            buf = reader.getData(node70);
                            dType = node70.getDataTypeObj();
                            System.out.println("Get data of type " + (Object)((Object)dType));
                            if (dType == DataType.DOUBLE64) {
                                System.out.println("Double data =");
                                DoubleBuffer dbuf = buf.asDoubleBuffer();
                                for (k = 0; k < dbuf.limit(); ++k) {
                                    System.out.println(k + "   " + dbuf.get(k));
                                }
                            }
                        }
                        returnList = reader.searchEvent(3, 5, 0);
                        if (returnList.size() < 1) {
                            System.out.println("GOT NOTHING IN SEARCH for T5N0");
                        } else {
                            System.out.println("Data for T5N0 ->");
                            node33 = returnList.get(0);
                            buf = reader.getData(node33);
                            dType = node33.getDataTypeObj();
                            System.out.println("Get data of type " + (Object)((Object)dType));
                            if (dType == DataType.SHORT16) {
                                System.out.println("Short data =");
                                ibuf = buf.asShortBuffer();
                                for (k = 0; k < ibuf.limit(); k = (int)((short)(k + 1))) {
                                    System.out.println(k + "   " + ((ShortBuffer)ibuf).get(k));
                                }
                            }
                        }
                        returnList = reader.searchEvent(3, 3, 3);
                        if (returnList.size() < 1) {
                            System.out.println("GOT NOTHING IN SEARCH for T3N3");
                            continue;
                        }
                        System.out.println("Data for T3N3 ->");
                        node33 = returnList.get(0);
                        buf = reader.getData(node33);
                        dType = node33.getDataTypeObj();
                        System.out.println("Get data of type " + (Object)((Object)dType));
                        if (dType != DataType.INT32) continue;
                        System.out.println("Int data =");
                        ibuf = buf.asIntBuffer();
                        for (k = 0; k < ibuf.limit(); ++k) {
                            System.out.println(k + "   " + ((IntBuffer)ibuf).get(k));
                        }
                    }
                    continue;
                }
                catch (EvioException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            long t2 = System.currentTimeMillis();
            long time = t2 - t1;
            double rate = 1000.0 * ((double)loops * (double)evCount) / (double)time;
            System.out.println("rate = " + String.format("%.3g", rate) + " Hz");
            System.out.println("time = " + time + " milliseconds");
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
    }
}

