/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.gui;

import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioSegment;

public enum Filter {
    EVERY(true),
    PHYSICS(false),
    PARTIAL(false),
    CONTROL(false),
    ROC_RAW(false);

    private boolean active;
    private int[] triggerTypes;
    private int triggerType = -1;

    private Filter(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public synchronized void setActive(boolean active) {
        this.active = active;
    }

    public synchronized void setTriggerType(int triggerType) {
        this.triggerType = triggerType;
    }

    public static synchronized boolean allow(EvioEvent event) {
        if (Filter.EVERY.active) {
            return true;
        }
        if (Filter.PHYSICS.active && PHYSICS.isPhysics(event)) {
            if (Filter.PHYSICS.triggerType == -1) {
                return true;
            }
            if (Filter.PHYSICS.triggerTypes == null) {
                return true;
            }
            for (int tType : Filter.PHYSICS.triggerTypes) {
                if (Filter.PHYSICS.triggerType != tType) continue;
                return true;
            }
            return false;
        }
        if (Filter.PARTIAL.active && PHYSICS.isPartialPhysics(event)) {
            if (Filter.PARTIAL.triggerType == -1) {
                return true;
            }
            if (Filter.PARTIAL.triggerTypes == null) {
                return true;
            }
            for (int tType : Filter.PARTIAL.triggerTypes) {
                if (Filter.PARTIAL.triggerType != tType) continue;
                return true;
            }
            return false;
        }
        return Filter.CONTROL.active && CONTROL.isControl(event);
    }

    public synchronized boolean allow2(EvioEvent event) {
        switch (this) {
            case EVERY: {
                return true;
            }
            case ROC_RAW: {
                return false;
            }
            case CONTROL: {
                return this.isControl(event);
            }
            case PARTIAL: {
                if (this.isPartialPhysics(event)) {
                    if (this.triggerType == -1) {
                        return true;
                    }
                    if (this.triggerTypes == null) {
                        return true;
                    }
                    for (int tType : this.triggerTypes) {
                        if (this.triggerType != tType) continue;
                        return true;
                    }
                }
            }
            case PHYSICS: {
                if (!this.isPhysics(event)) break;
                if (this.triggerType == -1) {
                    return true;
                }
                if (this.triggerTypes == null) {
                    return true;
                }
                for (int tType : this.triggerTypes) {
                    if (this.triggerType != tType) continue;
                    return true;
                }
                break;
            }
        }
        System.out.println("event reject 1");
        return false;
    }

    private boolean isPhysics(EvioBank bank) {
        if (bank == null) {
            return false;
        }
        BaseStructureHeader header = bank.getHeader();
        if (header.getDataType() != DataType.BANK && header.getDataType() != DataType.ALSOBANK) {
            return false;
        }
        int tag = header.getTag();
        if (tag < 65360 || tag > 65423) {
            return false;
        }
        int eventCount = header.getNumber();
        if (eventCount > 0) {
            EvioBank kid = (EvioBank)bank.getChildAt(0);
            if (kid == null) {
                return false;
            }
            EvioSegment seg = (EvioSegment)kid.getChildAt(1);
            if (seg == null) {
                return false;
            }
            short[] data = seg.getShortData();
            if (data == null) {
                return false;
            }
            this.triggerTypes = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                this.triggerTypes[i] = 0xFFFF & data[i];
            }
        } else {
            this.triggerTypes = null;
        }
        return true;
    }

    private boolean isControl(EvioBank bank) {
        if (bank == null) {
            return false;
        }
        BaseStructureHeader header = bank.getHeader();
        if (header.getLength() != 4) {
            return false;
        }
        if (header.getDataType() != DataType.UINT32) {
            return false;
        }
        int tag = bank.getHeader().getTag();
        return tag >= 65488 && tag <= 65492;
    }

    private boolean isPartialPhysics(EvioBank bank) {
        BaseStructureHeader header = bank.getHeader();
        if (header.getDataType() != DataType.BANK && header.getDataType() != DataType.ALSOBANK) {
            System.out.println("partial reject 0");
            return false;
        }
        int tag = bank.getHeader().getTag();
        if (tag >= 65360 && tag <= 65423) {
            System.out.println("partial reject 1");
            return false;
        }
        int eventCount = header.getNumber();
        if (eventCount > 0) {
            EvioBank kid = (EvioBank)bank.getChildAt(0);
            if (kid == null) {
                System.out.println("partial reject 2");
                return false;
            }
            EvioSegment seg = (EvioSegment)kid.getChildAt(1);
            if (seg == null) {
                System.out.println("partial reject 3");
                return false;
            }
            short[] data = seg.getShortData();
            if (data == null) {
                System.out.println("partial reject 4");
                return false;
            }
            this.triggerTypes = new int[data.length];
            for (int i = 0; i < data.length; ++i) {
                this.triggerTypes[i] = 0xFFFF & data[i];
            }
        } else {
            this.triggerTypes = null;
        }
        System.out.println("partial accept");
        return true;
    }

    private boolean isRocRaw(EvioBank bank) {
        BaseStructureHeader header = bank.getHeader();
        if (header.getDataType() != DataType.BANK || header.getDataType() != DataType.ALSOBANK) {
            return false;
        }
        EvioBank kid = (EvioBank)bank.getChildAt(0);
        if (kid == null) {
            return false;
        }
        header = kid.getHeader();
        int tag = header.getTag();
        if (tag < 65296 || tag > 65311) {
            return false;
        }
        return header.getDataType() == DataType.SEGMENT || header.getDataType() == DataType.ALSOSEGMENT;
    }
}

