/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.jlab.coda.et.EtAttachment;
import org.jlab.coda.et.EtEvent;
import org.jlab.coda.et.EtStation;
import org.jlab.coda.et.EtStationConfig;
import org.jlab.coda.et.EtSystem;
import org.jlab.coda.et.EtSystemOpen;
import org.jlab.coda.et.EtSystemOpenConfig;
import org.jlab.coda.et.enums.Mode;
import org.jlab.coda.et.enums.Modify;
import org.jlab.coda.et.exception.EtClosedException;
import org.jlab.coda.et.exception.EtDeadException;
import org.jlab.coda.et.exception.EtException;
import org.jlab.coda.et.exception.EtExistsException;
import org.jlab.coda.et.exception.EtTimeoutException;
import org.jlab.coda.et.exception.EtTooManyException;
import org.jlab.coda.et.exception.EtWakeUpException;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.gui.Filter;

public class EtHandler {
    private JPanel panel;
    private JTextField etName;
    private JTextField hostName;
    private JTextField stationName;
    private JSpinner mPort;
    private JSpinner tPort;
    private JSpinner statPos;
    private JRadioButton directButton;
    private JRadioButton multicastButton;
    private JRadioButton createStationButton;
    private JRadioButton firstButton;
    private JRadioButton lastButton;
    private JRadioButton posButton;
    private JRadioButton hostButton;
    private EtStationConfig stationConfig;
    private EtSystem etSystem;
    private EtStation station;
    private EtAttachment att;
    private boolean stationCreated;
    private String lastHost = "localhost";
    private int eventNum = 1;
    private ProcessEvents getEventThread;
    private volatile boolean die;
    private int currentIndex = -1;
    private int listLimit = 100;
    private final int maxListSize = 1000;
    private ArrayList<EvioEvent> eventList = new ArrayList(1000);
    private Filter eventFilter = Filter.EVERY;

    public Filter getEventFilter() {
        return this.eventFilter;
    }

    public void setEventFilter(Filter eventFilter) {
        this.eventFilter = eventFilter;
    }

    private synchronized void resetEventNumber() {
        this.eventNum = 1;
    }

    public synchronized void addEvent(EvioEvent event) {
        if (event == null || this.eventList.size() >= this.listLimit) {
            return;
        }
        if (!Filter.allow(event)) {
            System.out.println("ET FILTER REJECTS event -> " + event);
            return;
        }
        event.setEventNumber(this.eventNum++);
        this.eventList.add(event);
    }

    public synchronized EvioEvent getEvent(int index) {
        if (index < 1 || index > this.listLimit || index > this.eventList.size()) {
            return null;
        }
        this.currentIndex = index - 1;
        return this.eventList.get(this.currentIndex);
    }

    public synchronized EvioEvent getNextEvent() {
        int nextIndex = this.currentIndex + 1;
        if (nextIndex >= this.listLimit || nextIndex >= this.eventList.size()) {
            return null;
        }
        return this.eventList.get(++this.currentIndex);
    }

    public synchronized boolean hasNextEvent() {
        int nextIndex = this.currentIndex + 1;
        return nextIndex < this.listLimit && nextIndex < this.eventList.size();
    }

    public synchronized EvioEvent getPrevEvent() {
        int prevIndex = this.currentIndex - 1;
        if (prevIndex < 0) {
            return null;
        }
        return this.eventList.get(--this.currentIndex);
    }

    public synchronized int getListSize() {
        return this.eventList.size();
    }

    public synchronized int getCurrentEventIndex() {
        return this.currentIndex;
    }

    public synchronized void resetCurrentEventIndex() {
        this.currentIndex = -1;
    }

    public void setEventNum(int eventNum) {
        this.eventNum = eventNum;
    }

    public synchronized void clearList() {
        this.eventList.clear();
        this.currentIndex = -1;
        this.resetEventNumber();
    }

    public synchronized void clearList(int numberToDelete) {
        int listSize = this.eventList.size();
        if (numberToDelete < listSize) {
            for (int i = listSize; i > listSize - numberToDelete; --i) {
                this.eventList.remove(i - 1);
            }
            if (this.currentIndex >= this.eventList.size()) {
                this.currentIndex = -1;
            }
            return;
        }
        this.clearList();
    }

    public synchronized int getListLimit() {
        return this.listLimit;
    }

    public synchronized void setListLimit(int limit) {
        if (limit < 1 || limit == this.listLimit) {
            return;
        }
        if (limit > 1000) {
            limit = 1000;
        }
        if (limit < this.listLimit && limit < this.eventList.size()) {
            this.clearList(this.eventList.size() - limit);
        }
        this.listLimit = limit;
    }

    public synchronized void startFillingEventList() {
        if (this.getEventThread == null || !this.getEventThread.isAlive()) {
            this.die = false;
            this.getEventThread = new ProcessEvents();
            this.getEventThread.start();
        }
    }

    public synchronized void stopFillingEventList() {
        if (this.getEventThread == null || !this.getEventThread.isAlive()) {
            return;
        }
        this.die = true;
        try {
            this.etSystem.wakeUpAttachment(this.att);
            this.getEventThread.join(200L);
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
        }
        catch (EtException etException) {
            // empty catch block
        }
        this.getEventThread = null;
    }

    public JPanel createEtPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        final Color darkGreen = new Color(0, 160, 0);
        final Color darkRed = new Color(160, 0, 0);
        final JButton connectButton = new JButton("Connect");
        Border blackLine = BorderFactory.createLineBorder(Color.black);
        Border lowerEtched = BorderFactory.createEtchedBorder(1);
        Border empty = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        CompoundBorder compound = BorderFactory.createCompoundBorder(lowerEtched, empty);
        final JLabel status = new JLabel("  Press button to connect to ET system  ");
        status.setForeground(Color.BLUE);
        status.setVerticalTextPosition(0);
        status.setHorizontalTextPosition(0);
        status.setBorder(empty);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)status, "Center");
        ActionListener al_con = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = (JButton)e.getSource();
                if (button.getText().equals("Connect")) {
                    try {
                        EtSystemOpenConfig sysConfig = EtHandler.this.getEtSystemConfig();
                        if (sysConfig == null) {
                            return;
                        }
                        EtHandler.this.etSystem = EtHandler.this.connect(sysConfig);
                        if (EtHandler.this.etSystem == null) {
                            return;
                        }
                        EtHandler.this.att = EtHandler.this.attach(EtHandler.this.etSystem);
                        if (EtHandler.this.att == null) {
                            return;
                        }
                        EtHandler.this.startFillingEventList();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        status.setForeground(Color.red);
                        status.setText(" Failed to connect to ET system");
                        return;
                    }
                    status.setForeground(darkGreen);
                    status.setText(" Connected to ET system");
                    connectButton.setText("Disconnect");
                } else {
                    EtHandler.this.stopFillingEventList();
                    try {
                        EtHandler.this.etSystem.detach(EtHandler.this.att);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    try {
                        if (EtHandler.this.stationCreated) {
                            EtHandler.this.etSystem.removeStation(EtHandler.this.station);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    EtHandler.this.etSystem.close();
                    status.setForeground(darkRed);
                    status.setText(" Disconnected from ET system");
                    connectButton.setText("Connect");
                }
            }
        };
        connectButton.setAlignmentX(0.5f);
        connectButton.addActionListener(al_con);
        connectButton.setEnabled(true);
        JPanel pTopLabels = new JPanel();
        pTopLabels.setLayout(new GridLayout(2, 1, 0, 2));
        JLabel l1 = new JLabel("ET name");
        JLabel l2 = new JLabel("ET host");
        pTopLabels.add(l1);
        pTopLabels.add(l2);
        this.etName = new JTextField();
        this.etName.setEditable(true);
        this.hostName = new JTextField(this.lastHost);
        this.hostName.setEditable(true);
        this.hostName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTextField textField = (JTextField)e.getSource();
                String text = textField.getText();
                if (EtHandler.this.hostButton.isSelected()) {
                    EtHandler.this.lastHost = text;
                }
            }
        });
        this.hostName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                JTextField textField = (JTextField)e.getSource();
                String text = textField.getText();
                if (EtHandler.this.hostButton.isSelected()) {
                    EtHandler.this.lastHost = text;
                }
            }
        });
        JPanel pTopBoxes = new JPanel();
        pTopBoxes.setLayout(new GridLayout(2, 1, 0, 2));
        pTopBoxes.add(this.etName);
        pTopBoxes.add(this.hostName);
        this.hostButton = new JRadioButton("Host");
        JRadioButton localButton = new JRadioButton("Local");
        JRadioButton remoteButton = new JRadioButton("Remote");
        JRadioButton anywhereButton = new JRadioButton("Anywhere");
        this.hostButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.hostName.setText(EtHandler.this.lastHost);
                EtHandler.this.hostName.setEditable(true);
            }
        });
        localButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.hostName.setText("local");
                EtHandler.this.hostName.setEditable(false);
            }
        });
        remoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.hostName.setText("remote");
                EtHandler.this.hostName.setEditable(false);
            }
        });
        anywhereButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.hostName.setText("anywhere");
                EtHandler.this.hostName.setEditable(false);
            }
        });
        ButtonGroup group1 = new ButtonGroup();
        group1.add(this.hostButton);
        group1.add(localButton);
        group1.add(remoteButton);
        group1.add(anywhereButton);
        this.hostButton.setSelected(true);
        JPanel pTopButtons = new JPanel();
        pTopButtons.setLayout(new GridLayout(1, 4, 0, 2));
        pTopButtons.add(this.hostButton);
        pTopButtons.add(localButton);
        pTopButtons.add(remoteButton);
        pTopButtons.add(anywhereButton);
        JPanel topPanel = new JPanel();
        BorderLayout bl = new BorderLayout(10, 0);
        TitledBorder border1 = new TitledBorder(compound, "ET System", 1, 2, null, Color.BLUE);
        topPanel.setBorder(border1);
        topPanel.setLayout(bl);
        topPanel.add((Component)pTopLabels, "West");
        topPanel.add((Component)pTopBoxes, "Center");
        topPanel.add((Component)pTopButtons, "South");
        this.mPort = new JSpinner(new SpinnerNumberModel(11111, 1024, 65535, 1));
        this.tPort = new JSpinner(new SpinnerNumberModel(11111, 1024, 65535, 1));
        this.directButton = new JRadioButton("Direct");
        this.multicastButton = new JRadioButton("Multicast");
        this.multicastButton.setSelected(true);
        this.tPort.setEnabled(false);
        this.directButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.mPort.setEnabled(false);
                EtHandler.this.tPort.setEnabled(true);
            }
        });
        this.multicastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.mPort.setEnabled(true);
                EtHandler.this.tPort.setEnabled(false);
            }
        });
        ButtonGroup group2 = new ButtonGroup();
        group2.add(this.directButton);
        group2.add(this.multicastButton);
        JPanel methodPanel = new JPanel();
        methodPanel.setLayout(new GridLayout(2, 1));
        methodPanel.add(this.directButton);
        methodPanel.add(this.multicastButton);
        JPanel tcpPanel = new JPanel();
        tcpPanel.setLayout(new BorderLayout());
        tcpPanel.add((Component)new JLabel("TCP Port  "), "West");
        tcpPanel.add((Component)this.tPort, "Center");
        JPanel udpPanel = new JPanel();
        udpPanel.setLayout(new BorderLayout());
        udpPanel.add((Component)new JLabel("UDP Port  "), "West");
        udpPanel.add((Component)this.mPort, "Center");
        JPanel ipPanel = new JPanel();
        ipPanel.setLayout(new GridLayout(2, 1));
        ipPanel.add(tcpPanel);
        ipPanel.add(udpPanel);
        TitledBorder border2 = new TitledBorder(compound, "Connection", 1, 2, null, Color.BLUE);
        JPanel midPanel = new JPanel();
        midPanel.setBorder(border2);
        midPanel.setLayout(new GridLayout(1, 2));
        midPanel.add(methodPanel);
        midPanel.add(ipPanel);
        this.stationName = new JTextField();
        this.stationName.setEditable(true);
        this.createStationButton = new JRadioButton("Create");
        this.createStationButton.setSelected(true);
        JPanel statPanel = new JPanel();
        statPanel.setLayout(new BorderLayout(10, 0));
        statPanel.add((Component)new JLabel("Station Name"), "West");
        statPanel.add((Component)this.stationName, "Center");
        statPanel.add((Component)this.createStationButton, "East");
        this.statPos = new JSpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.posButton = new JRadioButton("Position");
        this.lastButton = new JRadioButton("Last");
        this.firstButton = new JRadioButton("First");
        ButtonGroup group3 = new ButtonGroup();
        group3.add(this.lastButton);
        group3.add(this.firstButton);
        group3.add(this.posButton);
        this.posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.statPos.setEnabled(true);
            }
        });
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.statPos.setEnabled(false);
            }
        });
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtHandler.this.statPos.setEnabled(false);
            }
        });
        this.lastButton.doClick();
        JPanel posButtonPanel = new JPanel();
        posButtonPanel.setLayout(new BoxLayout(posButtonPanel, 0));
        posButtonPanel.setBorder(new EmptyBorder(5, 0, 0, 0));
        posButtonPanel.add(this.lastButton);
        posButtonPanel.add(this.firstButton);
        posButtonPanel.add(this.posButton);
        posButtonPanel.add(this.statPos);
        TitledBorder border3 = new TitledBorder(compound, "Station", 1, 2, null, Color.BLUE);
        JPanel lowPanel = new JPanel();
        lowPanel.setBorder(border3);
        lowPanel.setLayout(new BorderLayout());
        lowPanel.add((Component)statPanel, "North");
        lowPanel.add((Component)posButtonPanel, "Center");
        JPanel centerPanel = new JPanel();
        GroupLayout layout1 = new GroupLayout(centerPanel);
        layout1.setHorizontalGroup(layout1.createParallelGroup().addComponent(topPanel).addComponent(midPanel).addComponent(lowPanel).addComponent(statusPanel));
        layout1.setVerticalGroup(layout1.createSequentialGroup().addComponent(topPanel).addComponent(midPanel).addComponent(lowPanel).addComponent(statusPanel));
        centerPanel.setLayout(layout1);
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)centerPanel, "Center");
        this.panel.add((Component)connectButton, "South");
        return this.panel;
    }

    private EtSystemOpenConfig getEtSystemConfig() {
        try {
            EtSystemOpenConfig config;
            boolean specifingHostname = false;
            String etSystem = this.etName.getText();
            String host = this.hostName.getText();
            if (etSystem == null || etSystem.length() < 1 || host == null || host.length() < 1) {
                JOptionPane.showMessageDialog(new JFrame(), "Enter et and host names", "Error", 0);
                return null;
            }
            boolean directConnection = this.directButton.isSelected();
            if (host.equals("local")) {
                host = ".local";
                specifingHostname = true;
            } else if (host.equals("remote")) {
                host = ".remote";
            } else if (host.equals("anywhere")) {
                host = ".anywhere";
            } else {
                specifingHostname = true;
            }
            if (directConnection) {
                if (!specifingHostname) {
                    throw new EtException("Specify a host's name (not remote, or anywhere) to make a direct connection.");
                }
                int port = ((SpinnerNumberModel)this.tPort.getModel()).getNumber().intValue();
                config = new EtSystemOpenConfig(etSystem, host, port);
            } else {
                ArrayList<String> mAddrs = new ArrayList<String>(1);
                mAddrs.add("239.200.0.0");
                int mcastPort = ((SpinnerNumberModel)this.mPort.getModel()).getNumber().intValue();
                config = new EtSystemOpenConfig(etSystem, host, mAddrs, mcastPort, 32);
            }
            return config;
        }
        catch (EtException ex) {
            JOptionPane.showMessageDialog(new JFrame(), ex.getMessage(), "Error", 0);
            return null;
        }
    }

    private EtAttachment attach(EtSystem system) {
        boolean exists;
        String statName = this.stationName.getText();
        if (statName == null || statName.length() < 1) {
            JOptionPane.showMessageDialog(new JFrame(), "Enter station name", "Error", 0);
            return null;
        }
        boolean create = this.createStationButton.isSelected();
        int position = -1;
        if (this.firstButton.isSelected()) {
            position = 1;
        } else if (this.posButton.isSelected()) {
            position = ((SpinnerNumberModel)this.statPos.getModel()).getNumber().intValue();
        }
        try {
            exists = system.stationExists(statName);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(new JFrame(), "Cannot communicate with ET", "Error", 0);
            return null;
        }
        catch (EtClosedException e) {
            JOptionPane.showMessageDialog(new JFrame(), "ET connection is closed", "Error", 0);
            return null;
        }
        catch (EtDeadException e) {
            JOptionPane.showMessageDialog(new JFrame(), "ET system is dead, Jim", "Error", 0);
            return null;
        }
        catch (EtException e) {
            JOptionPane.showMessageDialog(new JFrame(), e.getMessage(), "Error", 0);
            return null;
        }
        if (exists) {
            try {
                this.station = system.stationNameToObject(statName);
                this.stationCreated = false;
                return system.attach(this.station);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(new JFrame(), "cannot communicate with ET", "Error", 0);
            }
            catch (EtClosedException e) {
                JOptionPane.showMessageDialog(new JFrame(), "ET connection is closed", "Error", 0);
            }
            catch (EtDeadException e) {
                JOptionPane.showMessageDialog(new JFrame(), "ET system is dead, Jim", "Error", 0);
            }
            catch (EtException e) {
                JOptionPane.showMessageDialog(new JFrame(), e.getMessage(), "Error", 0);
            }
            catch (EtTooManyException e) {
                JOptionPane.showMessageDialog(new JFrame(), "too many attachments to station", "Error", 0);
            }
            return null;
        }
        if (!create) {
            JOptionPane.showMessageDialog(new JFrame(), "select create button to allow creating station", "Error", 0);
            return null;
        }
        try {
            if (this.stationConfig == null) {
                this.stationConfig = new EtStationConfig();
                try {
                    this.stationConfig.setBlockMode(0);
                    this.stationConfig.setCue(1);
                }
                catch (EtException e) {
                    // empty catch block
                }
            }
            this.station = system.createStation(this.stationConfig, statName, position);
            this.stationCreated = true;
            return system.attach(this.station);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(new JFrame(), "cannot communicate with ET", "Error", 0);
        }
        catch (EtClosedException e) {
            JOptionPane.showMessageDialog(new JFrame(), "ET connection is closed", "Error", 0);
        }
        catch (EtDeadException e) {
            JOptionPane.showMessageDialog(new JFrame(), "ET system is dead, Jim", "Error", 0);
        }
        catch (EtException e) {
            JOptionPane.showMessageDialog(new JFrame(), e.getMessage(), "Error", 0);
        }
        catch (EtTooManyException e) {
            JOptionPane.showMessageDialog(new JFrame(), "too many stations already exist", "Error", 0);
        }
        catch (EtExistsException e) {
            // empty catch block
        }
        return null;
    }

    private EtSystem connect(EtSystemOpenConfig config) {
        EtSystemOpen open;
        block12: {
            if (config == null) {
                return null;
            }
            config.setConnectRemotely(true);
            config.setWaitTime(3000L);
            open = new EtSystemOpen(config);
            try {
                open.connect();
            }
            catch (UnknownHostException ex) {
                JOptionPane.showMessageDialog(new JFrame(), config.getHost() + " is an unknown host", "Error", 0);
                return null;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
                return null;
            }
            catch (EtTooManyException ex) {
                int port = 0;
                Object[] hosts = open.getAllHosts();
                int[] ports = open.getAllPorts();
                if (hosts.length <= 1) break block12;
                String host = (String)JOptionPane.showInputDialog(new JFrame(), "Choose the ET system responding from host:", "ET System Choice", -1, null, hosts, hosts[0]);
                if (host == null) {
                    return null;
                }
                for (int i = 0; i < hosts.length; ++i) {
                    if (!host.equals(hosts[i])) continue;
                    port = ports[i];
                }
                try {
                    config.setHost(host);
                    config.setTcpPort(port);
                    config.setNetworkContactMethod(2);
                    open.connect();
                }
                catch (Exception except) {
                    JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
                    return null;
                }
            }
            catch (EtException ex) {
                JOptionPane.showMessageDialog(new JFrame(), "Cannot find or connect to " + config.getEtName(), "Error", 0);
                return null;
            }
        }
        EtSystem use = null;
        try {
            use = new EtSystem(open, 0);
        }
        catch (Exception ex) {
            open.disconnect();
            JOptionPane.showMessageDialog(new JFrame(), "Communication problems with " + config.getEtName() + " on " + config.getHost() + ":\n" + ex.getMessage(), "Error", 0);
        }
        return use;
    }

    private class ProcessEvents
    extends Thread {
        private ProcessEvents() {
        }

        @Override
        public void run() {
            if (EtHandler.this.etSystem == null) {
                return;
            }
            int chunk = 1;
            EtEvent[] events = null;
            EvioReader reader = null;
            EtHandler.this.resetEventNumber();
            do {
                if (EtHandler.this.die) {
                    return;
                }
                try {
                    events = EtHandler.this.etSystem.getEvents(EtHandler.this.att, Mode.TIMED, Modify.NOTHING, 1000000, chunk);
                }
                catch (EtTimeoutException e) {
                    continue;
                }
                catch (EtWakeUpException e) {
                    continue;
                }
                catch (Exception e) {
                    return;
                }
                block10: for (EtEvent ev : events) {
                    byte[] data = ev.getData();
                    if (data.length < 40) continue;
                    ByteBuffer buf = ByteBuffer.wrap(data);
                    try {
                        EvioEvent evioEv;
                        if (reader == null) {
                            reader = new EvioReader(buf);
                        } else {
                            reader.setBuffer(buf);
                        }
                        String dictionary = reader.getDictionaryXML();
                        while ((evioEv = reader.parseNextEvent()) != null) {
                            evioEv.setDictionaryXML(dictionary);
                            EtHandler.this.addEvent(evioEv);
                            if (EtHandler.this.eventList.size() < EtHandler.this.listLimit) continue;
                            break block10;
                        }
                    }
                    catch (EvioException e) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                try {
                    EtHandler.this.etSystem.putEvents(EtHandler.this.att, events);
                }
                catch (Exception e) {
                    return;
                }
            } while (EtHandler.this.eventList.size() < EtHandler.this.listLimit);
        }
    }
}

