/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio.graphics;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jlab.coda.cMsg.cMsgException;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;
import org.jlab.coda.jevio.IEvioListener;
import org.jlab.coda.jevio.IEvioProgressListener;
import org.jlab.coda.jevio.INameProvider;
import org.jlab.coda.jevio.NameProvider;
import org.jlab.coda.jevio.NameProviderFactory;
import org.jlab.coda.jevio.graphics.EventSource;
import org.jlab.coda.jevio.graphics.EventTreePanel;
import org.jlab.coda.jevio.graphics.cMsgHandler;

public class EventTreeMenu {
    JButton nextButton;
    JButton prevButton;
    private JMenuItem xmlExportItem;
    private JMenuItem openEventFile;
    private JMenu sourceConfig;
    private JTextField eventNumberInput;
    private EventTreePanel eventTreePanel;
    private EventSource eventSource = EventSource.FILE;
    private int eventIndex;
    private String dataFilePath;
    private String dictionaryFilePath;
    private String xmlFilePath;
    private FileNameExtensionFilter evioFileFilter;
    private EvioReader evioFileReader;
    private boolean isUserDictionary;
    private INameProvider userDictionary;
    private INameProvider fileDictionary;
    private INameProvider cmsgDictionary;
    private INameProvider currentDictionary;
    private JPanel cmsgPanel;
    private cMsgHandler cmsgHandler;
    private JButton connectButton;
    private boolean buttonWillConnect = true;
    private UpdateThread cmsgUpdateThread;
    private EventListenerList evioListenerList;

    public EventTreeMenu(EventTreePanel eventTreePanel) {
        this.eventTreePanel = eventTreePanel;
    }

    public EventTreePanel getEventTreePanel() {
        return this.eventTreePanel;
    }

    private void setEventSource(EventSource source) {
        if (source == this.eventSource) {
            return;
        }
        this.eventSource = source;
        this.eventTreePanel.setEvent(null);
        switch (source) {
            case CMSG: {
                this.sourceConfig.setEnabled(true);
                this.sourceConfig.removeAll();
                this.sourceConfig.add(this.cmsgPanel);
                this.sourceConfig.setText("cMsg config");
                this.openEventFile.setEnabled(false);
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(true);
                if (this.xmlExportItem.isEnabled()) {
                    this.xmlExportItem.setEnabled(false);
                }
                this.eventTreePanel.getEventInfoPanel().setDisplay("cMsg messages", 0, 0, null);
                this.cmsgUpdateThread = new UpdateThread();
                this.cmsgUpdateThread.start();
                break;
            }
            case FILE: {
                if (this.cmsgUpdateThread != null) {
                    this.cmsgUpdateThread.interrupt();
                }
                if (!this.buttonWillConnect) {
                    this.connectButton.doClick();
                }
                EvioReader evioFile = this.evioFileReader;
                this.sourceConfig.setText(" ");
                this.sourceConfig.setEnabled(false);
                this.openEventFile.setEnabled(true);
                if (evioFile == null) {
                    this.prevButton.setEnabled(false);
                    this.nextButton.setEnabled(false);
                } else {
                    this.prevButton.setEnabled(false);
                    this.nextButton.setEnabled(true);
                    this.xmlExportItem.setEnabled(true);
                }
                this.cmsgDictionary = null;
                String fileName = "";
                String dictSource = "     ";
                int eventCount = 0;
                if (evioFile != null) {
                    fileName = this.dataFilePath;
                    if (this.userDictionary != null) {
                        this.currentDictionary = this.userDictionary;
                        NameProvider.setProvider(this.currentDictionary);
                        dictSource = this.dictionaryFilePath;
                        this.eventTreePanel.getEventInfoPanel().setDictionary("from file");
                        this.isUserDictionary = true;
                    }
                    try {
                        eventCount = evioFile.getEventCount();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (EvioException e) {
                        // empty catch block
                    }
                    try {
                        EvioEvent event = this.evioFileReader.parseEvent(this.eventIndex);
                        if (event != null) {
                            this.eventTreePanel.setEvent(event);
                        }
                        if (this.eventIndex > 1) {
                            this.prevButton.setEnabled(true);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (EvioException e) {
                        // empty catch block
                    }
                }
                this.eventTreePanel.getEventInfoPanel().setDisplay(fileName, this.eventIndex, eventCount, dictSource);
                break;
            }
            case ET: {
                if (this.cmsgUpdateThread != null) {
                    this.cmsgUpdateThread.interrupt();
                }
                if (!this.buttonWillConnect) {
                    this.connectButton.doClick();
                }
                this.sourceConfig.setText(" ");
                this.sourceConfig.setEnabled(false);
                this.eventTreePanel.getEventInfoPanel().setDisplay("", 0, 0, null);
                if (this.xmlExportItem.isEnabled()) {
                    this.xmlExportItem.setEnabled(false);
                }
                this.eventTreePanel.getEventInfoPanel().setDisplay("ET buffers", 0, 0, null);
                break;
            }
        }
    }

    void addEventControlPanel() {
        this.nextButton = new JButton("next >");
        ActionListener al_next = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (EventTreeMenu.this.eventSource) {
                    case FILE: {
                        if (EventTreeMenu.this.evioFileReader == null) break;
                        try {
                            EvioEvent event = EventTreeMenu.this.evioFileReader.parseEvent(++EventTreeMenu.this.eventIndex);
                            if (event != null) {
                                EventTreeMenu.this.eventTreePanel.setEvent(event);
                            }
                            if (EventTreeMenu.this.eventIndex <= 1) break;
                            EventTreeMenu.this.prevButton.setEnabled(true);
                        }
                        catch (IOException e1) {
                            EventTreeMenu.this.eventIndex--;
                            e1.printStackTrace();
                        }
                        catch (EvioException e1) {
                            EventTreeMenu.this.eventIndex--;
                            e1.printStackTrace();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        break;
                    }
                    case CMSG: {
                        EvioEvent event;
                        if (EventTreeMenu.this.cmsgHandler == null || (event = EventTreeMenu.this.cmsgHandler.getNextEvent()) == null) break;
                        EventTreeMenu.this.eventTreePanel.setEvent(event);
                        if (!event.hasDictionaryXML()) break;
                        EventTreeMenu.this.cmsgDictionary = NameProviderFactory.createNameProvider(event.getDictionaryXML());
                        EventTreeMenu.this.currentDictionary = EventTreeMenu.this.cmsgDictionary;
                        NameProvider.setProvider(EventTreeMenu.this.currentDictionary);
                        EventTreeMenu.this.eventTreePanel.getEventInfoPanel().setDictionary("from cMsg message");
                        EventTreeMenu.this.eventTreePanel.refreshDescription();
                        EventTreeMenu.this.isUserDictionary = false;
                        break;
                    }
                }
            }
        };
        this.nextButton.addActionListener(al_next);
        this.prevButton = new JButton("< prev");
        this.prevButton.setEnabled(false);
        ActionListener al_prev = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (EventTreeMenu.this.eventSource) {
                    case FILE: {
                        if (EventTreeMenu.this.evioFileReader == null) break;
                        try {
                            if (EventTreeMenu.this.eventIndex < 2) break;
                            EvioEvent event = EventTreeMenu.this.evioFileReader.parseEvent(--EventTreeMenu.this.eventIndex);
                            if (event != null) {
                                EventTreeMenu.this.eventTreePanel.setEvent(event);
                            }
                            if (EventTreeMenu.this.eventIndex >= 2) break;
                            EventTreeMenu.this.prevButton.setEnabled(false);
                        }
                        catch (IOException e1) {
                            EventTreeMenu.this.eventIndex++;
                            e1.printStackTrace();
                        }
                        catch (EvioException e1) {
                            EventTreeMenu.this.eventIndex++;
                            e1.printStackTrace();
                        }
                        break;
                    }
                }
            }
        };
        this.prevButton.addActionListener(al_prev);
        ActionListener al_eventNumIn = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block12: {
                    try {
                        String num = EventTreeMenu.this.eventNumberInput.getText();
                        if (num == null) break block12;
                        int eventNum = Integer.parseInt(num);
                        switch (EventTreeMenu.this.eventSource) {
                            case FILE: {
                                if (eventNum > 0 && eventNum <= EventTreeMenu.this.evioFileReader.getEventCount()) {
                                    EventTreeMenu.this.eventIndex = eventNum;
                                    EvioEvent event = EventTreeMenu.this.evioFileReader.gotoEventNumber(EventTreeMenu.this.eventIndex);
                                    if (event != null) {
                                        EventTreeMenu.this.eventTreePanel.setEvent(event);
                                    }
                                    break;
                                }
                                EventTreeMenu.this.eventNumberInput.setText("");
                                break;
                            }
                            case CMSG: {
                                if (EventTreeMenu.this.cmsgHandler == null) break;
                                int qsize = EventTreeMenu.this.cmsgHandler.getQueueSize();
                                if (eventNum > 0 && eventNum <= qsize) {
                                    EventTreeMenu.this.cmsgHandler.clearQueue(eventNum - 1);
                                    EvioEvent event = EventTreeMenu.this.cmsgHandler.getNextEvent();
                                    if (event != null) {
                                        EventTreeMenu.this.eventTreePanel.setEvent(event);
                                        if (event.hasDictionaryXML()) {
                                            EventTreeMenu.this.cmsgDictionary = NameProviderFactory.createNameProvider(event.getDictionaryXML());
                                            EventTreeMenu.this.currentDictionary = EventTreeMenu.this.cmsgDictionary;
                                            NameProvider.setProvider(EventTreeMenu.this.currentDictionary);
                                            EventTreeMenu.this.eventTreePanel.getEventInfoPanel().setDictionary("from cMsg message");
                                            EventTreeMenu.this.eventTreePanel.refreshDescription();
                                            EventTreeMenu.this.isUserDictionary = false;
                                        }
                                    }
                                }
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException e1) {
                        EventTreeMenu.this.eventNumberInput.setText("");
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        };
        JLabel label = new JLabel("Go to event # ");
        this.eventNumberInput = new JTextField();
        this.eventNumberInput.addActionListener(al_eventNumIn);
        JPanel cPanel = this.eventTreePanel.getEventInfoPanel().controlPanel;
        cPanel.setBorder(new EmptyBorder(5, 8, 5, 8));
        cPanel.setLayout(new GridLayout(2, 2, 5, 5));
        cPanel.add(this.prevButton);
        cPanel.add(this.nextButton);
        cPanel.add(label);
        cPanel.add(this.eventNumberInput);
    }

    public JMenu createEventMenu() {
        final JMenu menu = new JMenu(" Event ");
        JLabel jl = new JLabel("Event Sources");
        jl.setBorder(new EmptyBorder(3, 20, 3, 0));
        jl.setHorizontalTextPosition(0);
        menu.add(jl);
        JRadioButtonMenuItem fileItem = new JRadioButtonMenuItem("File");
        JRadioButtonMenuItem cmsgItem = new JRadioButtonMenuItem("cMsg");
        JRadioButtonMenuItem etItem = new JRadioButtonMenuItem("ET (not available)");
        EmptyBorder eBorder = new EmptyBorder(3, 30, 3, 0);
        fileItem.setBorder(eBorder);
        cmsgItem.setBorder(eBorder);
        etItem.setBorder(eBorder);
        ActionListener cmsgListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EventTreeMenu.this.cmsgPanel == null) {
                    EventTreeMenu.this.cmsgPanel = EventTreeMenu.this.createCmsgPanel();
                }
                EventTreeMenu.this.setEventSource(EventSource.CMSG);
                menu.doClick();
            }
        };
        cmsgItem.addActionListener(cmsgListener);
        ActionListener fileListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.setEventSource(EventSource.FILE);
                menu.doClick();
            }
        };
        fileItem.addActionListener(fileListener);
        ActionListener etListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.setEventSource(EventSource.ET);
                menu.doClick();
            }
        };
        etItem.addActionListener(etListener);
        ButtonGroup group = new ButtonGroup();
        group.add(fileItem);
        group.add(cmsgItem);
        group.add(etItem);
        group.setSelected(fileItem.getModel(), true);
        menu.add(fileItem);
        menu.add(cmsgItem);
        menu.add(etItem);
        menu.addSeparator();
        this.sourceConfig = new JMenu("");
        this.sourceConfig.setText(" ");
        this.sourceConfig.setEnabled(false);
        menu.add(this.sourceConfig);
        return menu;
    }

    public JMenu createViewMenu() {
        JMenu menu = new JMenu(" View ");
        ActionListener al_hex = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                String txt = item.getText();
                if (txt.equals("Hexidecimal")) {
                    EventTreeMenu.this.eventTreePanel.setIntsInHex(true);
                    item.setText("Decimal");
                } else {
                    EventTreeMenu.this.eventTreePanel.setIntsInHex(false);
                    item.setText("Hexidecimal");
                }
                EventTreeMenu.this.eventTreePanel.refreshDisplay();
            }
        };
        JMenuItem hexItem = new JMenuItem("Hexidecimal");
        hexItem.addActionListener(al_hex);
        hexItem.setEnabled(true);
        menu.add(hexItem);
        ActionListener al_switchDict = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EventTreeMenu.this.switchDictionary()) {
                    EventTreeMenu.this.eventTreePanel.refreshDisplay();
                }
            }
        };
        JMenuItem switchDictItem = new JMenuItem("Switch dictionary");
        switchDictItem.addActionListener(al_switchDict);
        switchDictItem.setEnabled(true);
        menu.add(switchDictItem);
        return menu;
    }

    public JMenu createFileMenu() {
        JMenu menu = new JMenu(" File ");
        ActionListener al_oef = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.doOpenEventFile();
            }
        };
        this.openEventFile = new JMenuItem("Open Event File...");
        this.openEventFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openEventFile.addActionListener(al_oef);
        menu.add(this.openEventFile);
        ActionListener al_odf = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.doOpenDictionary();
            }
        };
        JMenuItem df_item = new JMenuItem("Open Dictionary...");
        df_item.addActionListener(al_odf);
        menu.add(df_item);
        menu.addSeparator();
        ActionListener al_xml = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.exportToXML();
            }
        };
        this.xmlExportItem = new JMenuItem("Export File to XML...");
        this.xmlExportItem.addActionListener(al_xml);
        this.xmlExportItem.setEnabled(false);
        menu.add(this.xmlExportItem);
        menu.addSeparator();
        ActionListener al_exit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        };
        JMenuItem exit_item = new JMenuItem("Quit");
        exit_item.addActionListener(al_exit);
        menu.add(exit_item);
        return menu;
    }

    private void doOpenEventFile() {
        EvioReader eFile = this.evioFileReader;
        EvioReader evioFile = this.openEventFile();
        if (eFile == evioFile) {
            return;
        }
        this.nextButton.setEnabled(evioFile != null);
        this.prevButton.setEnabled(false);
        this.xmlExportItem.setEnabled(evioFile != null);
        this.eventTreePanel.setEvent(null);
        this.nextButton.doClick();
    }

    public void manualOpenEventFile(File file) {
        EvioReader eFile = this.evioFileReader;
        EvioReader evioFile = this.openEventFile(file);
        if (eFile == evioFile) {
            return;
        }
        this.nextButton.setEnabled(evioFile != null);
        this.prevButton.setEnabled(false);
        this.xmlExportItem.setEnabled(evioFile != null);
        this.eventTreePanel.setEvent(null);
    }

    private void doOpenDictionary() {
        this.openDictionary();
    }

    public JPanel createCmsgPanel() {
        final Color darkGreen = new Color(0, 160, 0);
        final Color darkRed = new Color(160, 0, 0);
        final JTextField UDL = new JTextField("cMsg://localhost/cMsg/myNameSpace");
        final JTextField Subject = new JTextField("evio");
        final JTextField Type2 = new JTextField("*");
        UDL.setEditable(true);
        UDL.setMargin(new Insets(2, 5, 2, 5));
        ActionListener al_sub = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EventTreeMenu.this.cmsgHandler.subscribe(Subject.getText(), Type2.getText());
                }
                catch (cMsgException e1) {
                    e1.printStackTrace();
                    Subject.setText("evio");
                }
            }
        };
        Subject.addActionListener(al_sub);
        MouseAdapter ml_sub = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                try {
                    if (EventTreeMenu.this.cmsgHandler != null) {
                        EventTreeMenu.this.cmsgHandler.subscribe(Subject.getText(), Type2.getText());
                    }
                }
                catch (cMsgException e1) {
                    e1.printStackTrace();
                    Subject.setText("evio");
                }
            }
        };
        Subject.addMouseListener(ml_sub);
        Subject.setEditable(true);
        Subject.setMargin(new Insets(2, 5, 2, 5));
        ActionListener al_typ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EventTreeMenu.this.cmsgHandler.subscribe(Subject.getText(), Type2.getText());
                }
                catch (cMsgException e1) {
                    e1.printStackTrace();
                    Subject.setText("*");
                }
            }
        };
        Type2.addActionListener(al_typ);
        MouseAdapter ml_typ = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                try {
                    if (EventTreeMenu.this.cmsgHandler != null) {
                        EventTreeMenu.this.cmsgHandler.subscribe(Subject.getText(), Type2.getText());
                    }
                }
                catch (cMsgException e1) {
                    e1.printStackTrace();
                    Subject.setText("*");
                }
            }
        };
        Type2.addMouseListener(ml_typ);
        Type2.setEditable(true);
        Type2.setMargin(new Insets(2, 5, 2, 5));
        final JLabel status = new JLabel("  Press button to connect to cMsg server  ");
        status.setVerticalTextPosition(0);
        status.setBorder(new LineBorder(Color.black));
        JPanel p1 = new JPanel();
        ActionListener al_con = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton button = (JButton)e.getSource();
                if (button.getText().equals("Connect")) {
                    if (EventTreeMenu.this.cmsgHandler == null) {
                        EventTreeMenu.this.cmsgHandler = cMsgHandler.getInstance();
                    }
                    try {
                        EventTreeMenu.this.cmsgHandler.connect(UDL.getText());
                        EventTreeMenu.this.cmsgHandler.subscribe(Subject.getText(), Type2.getText());
                    }
                    catch (cMsgException e1) {
                        status.setForeground(Color.red);
                        status.setText(" Failed to connect to cmsg server");
                        return;
                    }
                    UDL.setEnabled(false);
                    status.setForeground(darkGreen);
                    status.setText(" Connected to cmsg server");
                    EventTreeMenu.this.connectButton.setText("Disconnect");
                    EventTreeMenu.this.buttonWillConnect = false;
                } else {
                    EventTreeMenu.this.cmsgHandler.disconnect();
                    UDL.setEnabled(true);
                    status.setForeground(darkRed);
                    status.setText(" Disconnected from cmsg server");
                    EventTreeMenu.this.connectButton.setText("Connect");
                    EventTreeMenu.this.buttonWillConnect = true;
                }
            }
        };
        this.connectButton = new JButton("Connect");
        this.connectButton.setAlignmentX(0.5f);
        this.connectButton.addActionListener(al_con);
        this.connectButton.setEnabled(true);
        ActionListener al_cq = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventTreeMenu.this.cmsgHandler.clearQueue();
            }
        };
        JButton clearQButton = new JButton("Clear Message Queue");
        clearQButton.setAlignmentX(0.5f);
        clearQButton.addActionListener(al_cq);
        p1.setBorder(new EmptyBorder(2, 5, 2, 5));
        p1.setLayout(new GridLayout(0, 2));
        p1.add(this.connectButton);
        p1.add(clearQButton);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(4, 0));
        JLabel label1 = new JLabel("UDL ");
        label1.setHorizontalAlignment(4);
        p3.add(label1);
        JLabel label2 = new JLabel("Subject ");
        label2.setHorizontalAlignment(4);
        p3.add(label2);
        JLabel label3 = new JLabel("Type ");
        label3.setHorizontalAlignment(4);
        p3.add(label3);
        JLabel label4 = new JLabel("Status ");
        label4.setHorizontalAlignment(4);
        p3.add(label4);
        JPanel p4 = new JPanel();
        p4.setLayout(new GridLayout(4, 0));
        p4.add(UDL);
        p4.add(Subject);
        p4.add(Type2);
        p4.add(status);
        Dimension d = p3.getPreferredSize();
        d.height = p4.getPreferredSize().height;
        p3.setMaximumSize(d);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        p2.add(Box.createRigidArea(new Dimension(5, 0)));
        p2.add(p3);
        p2.add(p4);
        p2.add(Box.createRigidArea(new Dimension(3, 0)));
        JPanel ptop = new JPanel();
        ptop.setLayout(new BoxLayout(ptop, 1));
        ptop.add(Box.createRigidArea(new Dimension(0, 3)));
        ptop.add(p2);
        ptop.add(Box.createRigidArea(new Dimension(0, 5)));
        ptop.add(p1);
        ptop.add(Box.createRigidArea(new Dimension(0, 5)));
        return ptop;
    }

    public boolean switchDictionary() {
        if (this.isUserDictionary) {
            switch (this.eventSource) {
                case FILE: {
                    if (this.fileDictionary == null) break;
                    this.currentDictionary = this.fileDictionary;
                    NameProvider.setProvider(this.currentDictionary);
                    this.eventTreePanel.refreshDescription();
                    this.eventTreePanel.getEventInfoPanel().setDictionary("from file");
                    this.isUserDictionary = false;
                    return true;
                }
                case CMSG: {
                    if (this.cmsgDictionary == null) break;
                    this.currentDictionary = this.cmsgDictionary;
                    NameProvider.setProvider(this.currentDictionary);
                    this.eventTreePanel.refreshDescription();
                    this.eventTreePanel.getEventInfoPanel().setDictionary("from cMsg message");
                    this.isUserDictionary = false;
                    return true;
                }
            }
        } else if (this.userDictionary != null) {
            this.currentDictionary = this.userDictionary;
            NameProvider.setProvider(this.currentDictionary);
            this.eventTreePanel.refreshDescription();
            this.eventTreePanel.getEventInfoPanel().setDictionary(this.dictionaryFilePath);
            this.isUserDictionary = true;
            return true;
        }
        return false;
    }

    public void exportToXML() {
        this.eventTreePanel.getProgressBar().setValue(0);
        JFileChooser chooser = new JFileChooser(this.xmlFilePath);
        chooser.setSelectedFile(null);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XML Evio Files", "xml");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this.eventTreePanel);
        if (returnVal == 0) {
            int answer;
            File selectedFile = chooser.getSelectedFile();
            this.xmlFilePath = selectedFile.getAbsolutePath();
            if (selectedFile.exists() && (answer = JOptionPane.showConfirmDialog(null, selectedFile.getPath() + "  already exists. Do you want to overwrite it?", "Overwite Existing File?", 0)) != 0) {
                return;
            }
            final IEvioProgressListener progressListener = new IEvioProgressListener(){

                @Override
                public void completed(int num, int total) {
                    int percentDone = (int)(100.0 * (double)num / (double)total);
                    EventTreeMenu.this.eventTreePanel.getProgressBar().setValue(percentDone);
                    EventTreeMenu.this.eventTreePanel.getProgressBar().repaint();
                }
            };
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        EventTreeMenu.this.evioFileReader.toXMLFile(EventTreeMenu.this.xmlFilePath, progressListener);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    EventTreeMenu.this.eventTreePanel.getProgressBar().setValue(0);
                    JOptionPane.showMessageDialog(EventTreeMenu.this.eventTreePanel, "XML Writing has completed.", "Done", 1);
                }
            };
            new Thread(runner).start();
        }
    }

    public void addEventFileExtension(String extension) {
        if (this.evioFileFilter == null) {
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", "ev", "evt", "evio", extension);
        } else {
            String[] exts = this.evioFileFilter.getExtensions();
            String[] newExts = Arrays.copyOf(exts, exts.length + 1);
            newExts[exts.length] = extension;
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", newExts);
        }
    }

    public void setEventFileExtensions(String[] extensions) {
        this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", extensions);
    }

    public EvioReader openEventFile() {
        this.eventTreePanel.getEventInfoPanel().setEventNumber(0);
        JFileChooser chooser = new JFileChooser(this.dataFilePath);
        chooser.setSelectedFile(null);
        if (this.evioFileFilter == null) {
            this.evioFileFilter = new FileNameExtensionFilter("EVIO Event Files", "ev", "evt", "evio");
        }
        chooser.setFileFilter(this.evioFileFilter);
        int returnVal = chooser.showOpenDialog(this.eventTreePanel);
        if (returnVal == 0) {
            this.eventTreePanel.getHeaderPanel().setHeader(null);
            File selectedFile = chooser.getSelectedFile();
            this.dataFilePath = selectedFile.getAbsolutePath();
            this.eventTreePanel.getEventInfoPanel().setSource(this.dataFilePath);
            try {
                if (this.evioFileReader != null) {
                    this.evioFileReader.close();
                    this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(0);
                }
                this.evioFileReader = new EvioReader(selectedFile);
                this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(this.evioFileReader.getEventCount());
                if (this.evioFileReader.hasDictionaryXML()) {
                    this.currentDictionary = this.fileDictionary = NameProviderFactory.createNameProvider(this.evioFileReader.getDictionaryXML());
                    NameProvider.setProvider(this.currentDictionary);
                    this.isUserDictionary = false;
                    this.eventTreePanel.getEventInfoPanel().setDictionary("from file");
                }
                this.eventIndex = 0;
            }
            catch (EvioException e) {
                this.evioFileReader = null;
                e.printStackTrace();
            }
            catch (IOException e) {
                this.evioFileReader = null;
                e.printStackTrace();
            }
        }
        this.connectEvioListeners();
        return this.evioFileReader;
    }

    public EvioReader openEventFile(File file) {
        this.eventTreePanel.getEventInfoPanel().setEventNumber(0);
        this.eventTreePanel.getHeaderPanel().setHeader(null);
        this.dataFilePath = file.getAbsolutePath();
        this.eventTreePanel.getEventInfoPanel().setSource(this.dataFilePath);
        try {
            if (this.evioFileReader != null) {
                this.evioFileReader.close();
                this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(0);
            }
            this.evioFileReader = new EvioReader(file);
            this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(this.evioFileReader.getEventCount());
            if (this.evioFileReader.hasDictionaryXML()) {
                this.currentDictionary = this.fileDictionary = NameProviderFactory.createNameProvider(this.evioFileReader.getDictionaryXML());
                NameProvider.setProvider(this.currentDictionary);
                this.isUserDictionary = false;
                this.eventTreePanel.getEventInfoPanel().setDictionary("from file");
            }
            this.eventIndex = 0;
        }
        catch (EvioException e) {
            this.evioFileReader = null;
            e.printStackTrace();
        }
        catch (IOException e) {
            this.evioFileReader = null;
            e.printStackTrace();
        }
        this.connectEvioListeners();
        return this.evioFileReader;
    }

    public EvioReader getEvioFileReader() {
        return this.evioFileReader;
    }

    public void setDefaultDataDir(String defaultDataDir) {
        this.dataFilePath = defaultDataDir;
    }

    public boolean openDictionary() {
        JFileChooser chooser = new JFileChooser(this.dictionaryFilePath);
        chooser.setSelectedFile(null);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Dictionary Files", "xml", "dict", "txt");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this.eventTreePanel);
        if (returnVal == 0) {
            File selectedFile = chooser.getSelectedFile();
            this.currentDictionary = this.userDictionary = NameProviderFactory.createNameProvider(selectedFile);
            NameProvider.setProvider(this.currentDictionary);
            this.isUserDictionary = true;
            this.dictionaryFilePath = selectedFile.getAbsolutePath();
            this.eventTreePanel.getEventInfoPanel().setDictionary(this.dictionaryFilePath);
            this.eventTreePanel.refreshDescription();
            return true;
        }
        return false;
    }

    public void openDictionaryFile(File file) {
        if (file != null) {
            this.currentDictionary = this.userDictionary = NameProviderFactory.createNameProvider(file);
            NameProvider.setProvider(this.currentDictionary);
            this.isUserDictionary = true;
            this.dictionaryFilePath = file.getAbsolutePath();
            this.eventTreePanel.getEventInfoPanel().setDictionary(this.dictionaryFilePath);
            this.eventTreePanel.refreshDescription();
        }
    }

    public void addEvioListener(IEvioListener listener) {
        if (listener == null) {
            return;
        }
        if (this.evioListenerList == null) {
            this.evioListenerList = new EventListenerList();
        }
        this.evioListenerList.add(IEvioListener.class, listener);
    }

    private void connectEvioListeners() {
        if (this.evioListenerList == null) {
            return;
        }
        EventParser parser = this.getEvioFileReader().getParser();
        EventListener[] listeners = this.evioListenerList.getListeners(IEvioListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            parser.addEvioListener((IEvioListener)listeners[i]);
        }
    }

    private class UpdateThread
    extends Thread {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (EventTreeMenu.this.cmsgHandler != null) {
                    EventTreeMenu.this.eventTreePanel.getEventInfoPanel().setNumberOfEvents(EventTreeMenu.this.cmsgHandler.getQueueSize());
                }
            }
        };

        private UpdateThread() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                SwingUtilities.invokeLater(this.r);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

