/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jlab.coda.jevio.BaseStructureHeader;
import org.jlab.coda.jevio.BlockHeaderV2;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.ByteDataTransformer;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventParser;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.IBlockHeader;
import org.jlab.coda.jevio.IEvioProgressListener;

public class EvioFile {
    private static final int MAGIC_OFFSET = 28;
    private static final int VERSION_OFFSET = 20;
    private static final int VERSION_MASK = 255;
    private MappedByteBuffer mappedByteBuffer;
    private ByteOrder byteOrder;
    private BlockHeaderV2 blockHeader2 = new BlockHeaderV2();
    private BlockHeaderV4 blockHeader4 = new BlockHeaderV4();
    private IBlockHeader blockHeader;
    private static final String ROOT_ELEMENT = "evio-data";
    private String xmlDictionary;
    private int eventNumber = 0;
    private int eventCount = -1;
    private int evioVersion;
    private String path;
    private EventParser parser;

    public EvioFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.path = file.getAbsolutePath();
        FileChannel inputChannel = fileInputStream.getChannel();
        this.mapFile(inputChannel);
        inputChannel.close();
        try {
            this.nextEvent();
        }
        catch (EvioException e) {
            throw new IOException("Failed reading first event", e);
        }
        this.rewind();
        this.parser = new EventParser();
    }

    public EvioFile(String path) throws IOException {
        this(new File(path));
    }

    public String getPath() {
        return this.path;
    }

    public EventParser getParser() {
        return this.parser;
    }

    public void setParser(EventParser parser) {
        if (parser != null) {
            this.parser = parser;
        }
    }

    public String getXmlDictionary() {
        return this.xmlDictionary;
    }

    public boolean hasDictionary() {
        return this.xmlDictionary != null;
    }

    public int getNumEventsRemaining() throws EvioException {
        return this.getEventCount() - this.eventNumber;
    }

    private synchronized void mapFile(FileChannel inputChannel) throws IOException {
        long sz = inputChannel.size();
        this.mappedByteBuffer = inputChannel.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
    }

    public int fileSize() {
        return this.mappedByteBuffer.capacity();
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    protected synchronized ReadStatus nextBlockHeader() {
        if (this.mappedByteBuffer.remaining() < 32) {
            this.mappedByteBuffer.clear();
            return ReadStatus.END_OF_FILE;
        }
        try {
            this.byteOrder = this.mappedByteBuffer.order();
            int magicNumber = this.mappedByteBuffer.getInt(28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.mappedByteBuffer.order(this.byteOrder);
            }
            int version = this.mappedByteBuffer.getInt(20) & 0xFF;
            try {
                if (version > 0 && version < 4) {
                    this.blockHeader2.setBufferStartingPosition(this.mappedByteBuffer.position());
                    this.blockHeader2.setSize(this.mappedByteBuffer.getInt());
                    this.blockHeader2.setNumber(this.mappedByteBuffer.getInt());
                    this.blockHeader2.setHeaderLength(this.mappedByteBuffer.getInt());
                    this.blockHeader2.setStart(this.mappedByteBuffer.getInt());
                    this.blockHeader2.setEnd(this.mappedByteBuffer.getInt());
                    this.mappedByteBuffer.getInt();
                    this.blockHeader2.setVersion(version);
                    this.blockHeader2.setReserved1(this.mappedByteBuffer.getInt());
                    this.blockHeader2.setMagicNumber(this.mappedByteBuffer.getInt());
                    this.blockHeader = this.blockHeader2;
                } else if (version >= 4) {
                    this.blockHeader4.setBufferStartingPosition(this.mappedByteBuffer.position());
                    this.blockHeader4.setSize(this.mappedByteBuffer.getInt());
                    this.blockHeader4.setNumber(this.mappedByteBuffer.getInt());
                    this.blockHeader4.setHeaderLength(this.mappedByteBuffer.getInt());
                    this.blockHeader4.setEventCount(this.mappedByteBuffer.getInt());
                    this.mappedByteBuffer.getInt();
                    this.blockHeader4.parseToBitInfo(this.mappedByteBuffer.getInt());
                    this.blockHeader4.setVersion(version);
                    this.mappedByteBuffer.getInt();
                    this.blockHeader4.setMagicNumber(this.mappedByteBuffer.getInt());
                    this.blockHeader = this.blockHeader4;
                } else {
                    System.err.println("ERROR unsupported evio version number in file");
                    return ReadStatus.EVIO_EXCEPTION;
                }
                if (this.evioVersion < 1) {
                    this.evioVersion = version;
                }
            }
            catch (EvioException e) {
                e.printStackTrace();
                return ReadStatus.EVIO_EXCEPTION;
            }
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            this.mappedByteBuffer.clear();
            return ReadStatus.UNKNOWN_ERROR;
        }
        return ReadStatus.SUCCESS;
    }

    public synchronized EvioEvent nextEvent() throws EvioException {
        int padding;
        int type;
        int dt;
        int bytesRemaining;
        EvioEvent event = new EvioEvent();
        BaseStructureHeader header = event.getHeader();
        boolean isFirstEvent = false;
        if (this.mappedByteBuffer.position() == 0) {
            ReadStatus status = this.nextBlockHeader();
            if (status != ReadStatus.SUCCESS) {
                throw new EvioException("Failed reading block header in nextEvent.");
            }
            isFirstEvent = true;
        }
        if ((bytesRemaining = this.blockBytesRemaining()) < 0) {
            throw new EvioException("Number of block bytes remaining is negative.");
        }
        if (bytesRemaining == 0) {
            ReadStatus status = this.nextBlockHeader();
            if (status == ReadStatus.SUCCESS) {
                return this.nextEvent();
            }
            if (status == ReadStatus.END_OF_FILE) {
                return null;
            }
            throw new EvioException("Failed reading block header in nextEvent.");
        }
        if (this.blockHeader.getBufferEndingPosition() == (long)this.mappedByteBuffer.position()) {
            return null;
        }
        int length = this.mappedByteBuffer.getInt();
        if (length < 1) {
            return null;
        }
        header.setLength(length);
        if (this.evioVersion < 4 && (bytesRemaining -= 4) == 0) {
            ReadStatus status = this.nextBlockHeader();
            if (status == ReadStatus.END_OF_FILE) {
                return null;
            }
            if (status != ReadStatus.SUCCESS) {
                throw new EvioException("Failed reading block header in nextEvent.");
            }
            bytesRemaining = this.blockBytesRemaining();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            header.setTag(ByteDataTransformer.shortBitsToInt(this.mappedByteBuffer.getShort()));
            dt = ByteDataTransformer.byteBitsToInt(this.mappedByteBuffer.get());
            type = dt & 0x3F;
            padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            event.setXmlNames();
            header.setNumber(ByteDataTransformer.byteBitsToInt(this.mappedByteBuffer.get()));
        } else {
            header.setNumber(ByteDataTransformer.byteBitsToInt(this.mappedByteBuffer.get()));
            dt = ByteDataTransformer.byteBitsToInt(this.mappedByteBuffer.get());
            type = dt & 0x3F;
            padding = dt >>> 6;
            if (dt == 64) {
                type = DataType.TAGSEGMENT.getValue();
                padding = 0;
            }
            header.setDataType(type);
            header.setPadding(padding);
            event.setXmlNames();
            header.setTag(ByteDataTransformer.shortBitsToInt(this.mappedByteBuffer.getShort()));
        }
        bytesRemaining -= 4;
        int eventDataSizeInts = header.getLength() - 1;
        int eventDataSizeBytes = 4 * eventDataSizeInts;
        try {
            byte[] bytes = new byte[eventDataSizeBytes];
            int bytesToGo = eventDataSizeBytes;
            int offset = 0;
            if (this.evioVersion < 4) {
                while (bytesToGo > bytesRemaining) {
                    this.mappedByteBuffer.get(bytes, offset, bytesRemaining);
                    ReadStatus status = this.nextBlockHeader();
                    if (status == ReadStatus.END_OF_FILE) {
                        return null;
                    }
                    if (status != ReadStatus.SUCCESS) {
                        throw new EvioException("Failed reading block header after crossing boundary in nextEvent.");
                    }
                    bytesToGo -= bytesRemaining;
                    offset += bytesRemaining;
                    bytesRemaining = this.blockBytesRemaining();
                }
            }
            this.mappedByteBuffer.get(bytes, offset, bytesToGo);
            event.setRawBytes(bytes);
            event.setByteOrder(this.byteOrder);
            if (isFirstEvent && this.blockHeader.hasDictionary()) {
                if (this.xmlDictionary == null) {
                    this.xmlDictionary = event.getStringData()[0];
                }
                return this.nextEvent();
            }
            event.setEventNumber(++this.eventNumber);
            return event;
        }
        catch (OutOfMemoryError ome) {
            System.err.println("Out Of Memory\neventDataSizeBytes = " + eventDataSizeBytes + "\n" + "bytes Remaining = " + bytesRemaining + "\n" + "event Count: " + this.eventCount);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized EvioEvent parseNextEvent() throws EvioException {
        EvioEvent event = this.nextEvent();
        if (event != null) {
            this.parseEvent(event);
        }
        return event;
    }

    public synchronized void parseEvent(EvioEvent evioEvent) throws EvioException {
        this.parser.parseEvent(evioEvent);
    }

    private int blockBytesRemaining() {
        try {
            return this.blockHeader.bytesRemaining(this.mappedByteBuffer.position());
        }
        catch (EvioException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void rewind() {
        this.mappedByteBuffer.position(0);
        this.eventNumber = 0;
    }

    public int position() {
        return this.mappedByteBuffer.position();
    }

    public void position(int position) {
        this.mappedByteBuffer.position(position);
    }

    public void close() {
        this.mappedByteBuffer.clear();
    }

    public IBlockHeader getCurrentBlockHeader() {
        return this.blockHeader;
    }

    public EvioEvent gotoEventNumber(int evNumber) {
        if (evNumber < 1) {
            return null;
        }
        this.rewind();
        try {
            for (int i = 1; i < evNumber; ++i) {
                EvioEvent event = this.nextEvent();
                if (event != null) continue;
                throw new EvioException("Asked to go to event: " + evNumber + ", which is beyond the end of file");
            }
            return this.parseNextEvent();
        }
        catch (EvioException e) {
            e.printStackTrace();
            return null;
        }
    }

    public WriteStatus toXMLFile(String path) {
        return this.toXMLFile(path, null);
    }

    public WriteStatus toXMLFile(String path, IEvioProgressListener progressListener) {
        FileOutputStream fos;
        try {
            fos = new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return WriteStatus.CANNOT_OPEN_FILE;
        }
        try {
            XMLStreamWriter xmlWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(fos);
            xmlWriter.writeStartDocument();
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeComment("Event source file: " + path);
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeStartElement(ROOT_ELEMENT);
            xmlWriter.writeAttribute("numevents", "" + this.getEventCount());
            this.rewind();
            try {
                EvioEvent event;
                while ((event = this.parseNextEvent()) != null) {
                    event.toXML(xmlWriter);
                    if (progressListener == null) continue;
                    progressListener.completed(event.getEventNumber(), this.getEventCount());
                }
            }
            catch (EvioException e) {
                e.printStackTrace();
                return WriteStatus.UNKNOWN_ERROR;
            }
            xmlWriter.writeCharacters("\n");
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.flush();
            xmlWriter.close();
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            return WriteStatus.UNKNOWN_ERROR;
        }
        catch (FactoryConfigurationError e) {
            return WriteStatus.UNKNOWN_ERROR;
        }
        catch (EvioException e) {
            return WriteStatus.EVIO_EXCEPTION;
        }
        this.rewind();
        System.out.println("XML write was successful");
        return WriteStatus.SUCCESS;
    }

    public int getEventCount() throws EvioException {
        System.out.println("\nCalling getEventCount()\n");
        if (this.eventCount < 0) {
            this.rewind();
            this.eventCount = 0;
            if (this.evioVersion >= 4) {
                ReadStatus status;
                while ((status = this.nextBlockHeader()) != ReadStatus.END_OF_FILE) {
                    if (status != ReadStatus.SUCCESS) {
                        throw new EvioException("Failed reading block header while counting events.");
                    }
                    this.eventCount += this.blockHeader4.getEventCount();
                    this.mappedByteBuffer.position((int)this.blockHeader4.nextBufferStartingPosition());
                }
            } else {
                while (this.nextEvent() != null) {
                    ++this.eventCount;
                }
            }
            this.rewind();
        }
        return this.eventCount;
    }

    public static boolean compareEventFiles(File evFile1, File evFile2) {
        long size2;
        if (evFile1 == null || evFile2 == null) {
            System.out.println("In compareEventFiles, one or both files are null.");
            return false;
        }
        if (!evFile1.exists() || !evFile2.exists()) {
            System.out.println("In compareEventFiles, one or both files do not exist.");
            return false;
        }
        if (evFile1.isDirectory() || evFile2.isDirectory()) {
            System.out.println("In compareEventFiles, one or both files is a directory.");
            return false;
        }
        if (!evFile1.canRead() || !evFile2.canRead()) {
            System.out.println("In compareEventFiles, one or both files cannot be read.");
            return false;
        }
        String name1 = evFile1.getName();
        String name2 = evFile2.getName();
        long size1 = evFile1.length();
        if (size1 != (size2 = evFile2.length())) {
            System.out.println(name1 + " and " + name2 + " have the different lengths.");
            System.out.println(name1 + ": " + size1);
            System.out.println(name2 + ": " + size2);
            return false;
        }
        System.out.println(name1 + " and " + name2 + " have the same length: " + size1);
        try {
            EvioFile evioFile1 = new EvioFile(evFile1);
            EvioFile evioFile2 = new EvioFile(evFile2);
            int evCount1 = evioFile1.getEventCount();
            int evCount2 = evioFile2.getEventCount();
            if (evCount1 != evCount2) {
                System.out.println(name1 + " and " + name2 + " have the different #events.");
                System.out.println(name1 + ": " + evCount1);
                System.out.println(name2 + ": " + evCount2);
                return false;
            }
            System.out.println(name1 + " and " + name2 + " have the same #events: " + evCount1);
        }
        catch (EvioException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        System.out.print("Byte by byte comparison...");
        System.out.flush();
        int onetenth = (int)(1L + size1 / 10L);
        try {
            FileInputStream fis1 = new FileInputStream(evFile1);
            FileInputStream fis2 = new FileInputStream(evFile1);
            int i = 0;
            while ((long)i < size1) {
                try {
                    int byte1 = fis1.read();
                    int byte2 = fis2.read();
                    if (byte1 != byte2) {
                        System.out.println(name1 + " and " + name2 + " different at byte offset: " + i);
                        return false;
                    }
                    if (i % onetenth == 0) {
                        System.out.print(".");
                        System.out.flush();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                ++i;
            }
            System.out.println("");
            try {
                fis1.close();
                fis2.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        System.out.println("files " + name1 + " and " + evFile2.getPath() + " are identical.");
        return true;
    }

    public static enum WriteStatus {
        SUCCESS,
        CANNOT_OPEN_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }

    public static enum ReadStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        UNKNOWN_ERROR;

    }
}

