/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jlab.coda.jevio.BaseStructure;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EventWriter;
import org.jlab.coda.jevio.EvioException;

public class EvioCompactEventWriter {
    private ByteBuffer byteBuffer;
    private int bufferSize;
    private int buffersWrittenToFile;
    private int blockCountMax;
    private int blockRoomForData;
    private int blockNumber = 1;
    private int currentHeaderPosition;
    private int currentBlockSize;
    private int currentBlockEventCount;
    private String xmlDictionary;
    private int eventsWrittenToBuffer;
    private int headerBytes = 32;
    private ByteOrder byteOrder;
    private boolean closed;
    private File currentFile;
    private FileOutputStream fileOutputStream;
    private FileChannel fileChannel;
    private int fileCount;
    public String baseFileName;
    private String directory;
    private int split;
    private int extensionIndex;
    private boolean overWriteOK;

    public void generateBaseFileName(String baseName, int runNumber) {
        this.baseFileName = baseName.replace("%d", "" + runNumber);
        if (this.baseFileName.contains("$(")) {
            Pattern pattern = Pattern.compile("\\$\\((.*?)\\)");
            Matcher matcher = pattern.matcher(this.baseFileName);
            StringBuffer result = new StringBuffer(100);
            while (matcher.find()) {
                String envVar = matcher.group(1);
                String envVal = System.getenv(envVar);
                if (envVal == null) {
                    envVal = "";
                }
                matcher.appendReplacement(result, envVal);
            }
            matcher.appendTail(result);
            this.baseFileName = result.toString();
        }
        this.extensionIndex = this.baseFileName.lastIndexOf(".");
    }

    public String generateFileName() {
        StringBuilder fileName = new StringBuilder(this.baseFileName);
        if (this.split > 0) {
            String splitNum = String.format("%06d", this.fileCount++);
            if (this.extensionIndex > 0) {
                fileName.insert(this.extensionIndex, splitNum);
            } else {
                fileName.append(splitNum);
            }
        }
        if (this.directory != null) {
            fileName.insert(0, "/");
            fileName.insert(0, this.directory);
        }
        return fileName.toString();
    }

    public EvioCompactEventWriter(String baseFilename, String directory, int runNumber, int split, int bufferSize, ByteOrder byteOrder, String xmlDictionary) throws EvioException {
        this(baseFilename, directory, runNumber, split, 1000000, 10000, bufferSize, byteOrder, xmlDictionary, false);
    }

    public EvioCompactEventWriter(String baseFilename, String directory, int runNumber, int split, int blockSizeMax, int blockCountMax, int bufferSize, ByteOrder byteOrder, String xmlDictionary, boolean overWriteOK) throws EvioException {
        if (baseFilename == null) {
            throw new EvioException("baseFileName arg is null");
        }
        if (blockSizeMax / 4 < EventWriter.MIN_BLOCK_SIZE) {
            throw new EvioException("blockSizeMax arg must be bigger or 0");
        }
        if (blockSizeMax / 4 > EventWriter.MAX_BLOCK_SIZE) {
            throw new EvioException("blockSizeMax arg must be smaller");
        }
        if (blockCountMax < EventWriter.MIN_BLOCK_COUNT) {
            throw new EvioException("blockCountMax arg must be bigger");
        }
        if (blockCountMax > EventWriter.MAX_BLOCK_COUNT) {
            throw new EvioException("blockCountMax arg must be smaller");
        }
        if (bufferSize < 72) {
            throw new EvioException("bufferSize arg must be larger (suggest > 10MB)");
        }
        this.split = split;
        this.directory = directory;
        this.bufferSize = bufferSize;
        this.blockCountMax = blockCountMax;
        this.xmlDictionary = xmlDictionary;
        this.overWriteOK = overWriteOK;
        this.fileCount = 0;
        this.generateBaseFileName(baseFilename, runNumber);
        String fileName = this.generateFileName();
        this.currentFile = new File(fileName);
        if (!overWriteOK && this.currentFile.exists() && this.currentFile.isFile()) {
            throw new EvioException("File exists but user requested no over-writing, " + this.currentFile.getPath());
        }
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        this.byteBuffer.order(byteOrder);
        this.byteOrder = byteOrder;
        this.blockNumber = 1;
        this.blockRoomForData = blockSizeMax - this.headerBytes;
        this.currentBlockSize = 8;
        if (xmlDictionary == null) {
            this.writeHeader(8, 0, this.blockNumber++, false, false, true, false);
        } else {
            this.writeHeader(8, 0, this.blockNumber++, true, false, true, false);
            this.writeDictionary();
        }
        this.writeEmptyLastBlockHeader(this.blockNumber);
    }

    private void writeEmptyLastBlockHeader(int blockNumber) throws EvioException {
        this.writeHeader(8, 0, blockNumber, false, true, false, true);
    }

    private void writeHeader(int words, int eventCount, int blockNumber, boolean hasDictionary, boolean isLast, boolean currentHeader, boolean absoluteMode) throws EvioException {
        if (this.byteBuffer.remaining() < 32) {
            throw new EvioException("Undersized internal buffer");
        }
        if (currentHeader) {
            this.currentHeaderPosition = this.byteBuffer.position();
        }
        if (absoluteMode) {
            int pos = this.byteBuffer.position();
            this.byteBuffer.putInt(pos, words);
            this.byteBuffer.putInt(pos + 4, blockNumber);
            this.byteBuffer.putInt(pos + 8, 8);
            this.byteBuffer.putInt(pos + 12, eventCount);
            this.byteBuffer.putInt(pos + 16, 0);
            this.byteBuffer.putInt(pos + 20, BlockHeaderV4.generateSixthWord(4, hasDictionary, isLast, 0));
            this.byteBuffer.putInt(pos + 24, 0);
            this.byteBuffer.putInt(pos + 28, -1059454720);
        } else {
            this.byteBuffer.putInt(words);
            this.byteBuffer.putInt(blockNumber);
            this.byteBuffer.putInt(8);
            this.byteBuffer.putInt(eventCount);
            this.byteBuffer.putInt(0);
            this.byteBuffer.putInt(BlockHeaderV4.generateSixthWord(4, hasDictionary, isLast, 0));
            this.byteBuffer.putInt(0);
            this.byteBuffer.putInt(-1059454720);
        }
    }

    private void writeDictionary() throws EvioException {
        if (this.xmlDictionary == null || this.xmlDictionary.length() < 1) {
            throw new EvioException("no dictionary");
        }
        byte[] dictBytes = BaseStructure.stringsToRawBytes(new String[]{this.xmlDictionary});
        this.byteBuffer.putInt(dictBytes.length / 4 + 1);
        if (this.byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            this.byteBuffer.putShort((short)0);
            this.byteBuffer.put((byte)DataType.CHARSTAR8.getValue());
            this.byteBuffer.put((byte)0);
        } else {
            this.byteBuffer.put((byte)0);
            this.byteBuffer.put((byte)DataType.CHARSTAR8.getValue());
            this.byteBuffer.putShort((short)0);
        }
        this.byteBuffer.put(dictBytes);
        this.currentBlockSize += 2 + dictBytes.length / 4;
        this.byteBuffer.putInt(this.currentHeaderPosition, this.currentBlockSize);
    }

    public synchronized void writeEvent(ByteBuffer eventBuffer) throws EvioException, IOException {
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        if (eventBuffer.order() != this.byteOrder) {
            throw new EvioException("event is in wrong byte order");
        }
        int currentEventBytes = eventBuffer.remaining();
        if (currentEventBytes % 4 != 0) {
            throw new EvioException("bad eventBuffer format");
        }
        int currentSizeIncrease = currentEventBytes;
        boolean writeNewBlockHeader = true;
        if (currentEventBytes + 4 * this.currentBlockSize - this.headerBytes <= this.blockRoomForData && this.eventsWrittenToBuffer < this.blockCountMax || this.eventsWrittenToBuffer < 1) {
            writeNewBlockHeader = false;
        } else {
            currentSizeIncrease += this.headerBytes;
        }
        if (this.bufferSize - this.byteBuffer.position() - this.headerBytes < currentSizeIncrease && this.flushToFile()) {
            writeNewBlockHeader = false;
        }
        if (writeNewBlockHeader) {
            this.currentBlockSize = 8;
            this.currentBlockEventCount = 0;
            this.writeHeader(this.currentBlockSize, 1, this.blockNumber++, false, false, true, false);
        }
        this.currentBlockSize += currentEventBytes / 4;
        ++this.currentBlockEventCount;
        this.byteBuffer.putInt(this.currentHeaderPosition, this.currentBlockSize);
        this.byteBuffer.putInt(this.currentHeaderPosition + 12, this.currentBlockEventCount);
        this.byteBuffer.put(eventBuffer);
        this.writeEmptyLastBlockHeader(this.blockNumber);
        ++this.eventsWrittenToBuffer;
    }

    public synchronized boolean flushToFile() throws EvioException, IOException {
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        if (this.eventsWrittenToBuffer < 1) {
            return false;
        }
        this.byteBuffer.position(this.byteBuffer.position() + this.headerBytes);
        this.byteBuffer.flip();
        if (this.buffersWrittenToFile < 1) {
            try {
                this.fileOutputStream = new FileOutputStream(this.currentFile, false);
                this.fileChannel = this.fileOutputStream.getChannel();
            }
            catch (FileNotFoundException e) {
                throw new EvioException("File could not be opened for writing, " + this.currentFile.getPath(), e);
            }
        } else {
            this.fileChannel.position(this.fileChannel.position() - 32L);
        }
        this.fileChannel.write(this.byteBuffer);
        this.fileChannel.force(true);
        this.byteBuffer.clear();
        this.blockNumber = 1;
        this.eventsWrittenToBuffer = 0;
        this.currentBlockSize = 8;
        this.currentBlockEventCount = 0;
        if (this.xmlDictionary == null) {
            this.writeHeader(8, 0, this.blockNumber++, false, false, true, false);
        } else {
            this.writeHeader(8, 0, this.blockNumber++, true, false, true, false);
            this.writeDictionary();
        }
        this.writeEmptyLastBlockHeader(this.blockNumber);
        ++this.buffersWrittenToFile;
        if (this.split < 1 || this.buffersWrittenToFile < this.split) {
            return false;
        }
        this.fileOutputStream.close();
        this.fileOutputStream = null;
        String fileName = this.generateFileName();
        this.currentFile = new File(fileName);
        if (!this.overWriteOK && this.currentFile.exists() && this.currentFile.isFile()) {
            throw new EvioException("File exists but user requested no over-writing, " + this.currentFile.getPath());
        }
        this.buffersWrittenToFile = 0;
        return true;
    }

    public synchronized ByteBuffer getByteBuffer() {
        ByteBuffer buf = this.byteBuffer.duplicate();
        buf.position(buf.position() + this.headerBytes);
        buf.flip();
        return buf;
    }

    private static void printBuffer(ByteBuffer buf, int lenInInts) {
        IntBuffer ibuf = buf.asIntBuffer();
        lenInInts = lenInInts > ibuf.capacity() ? ibuf.capacity() : lenInInts;
        for (int i = 0; i < lenInInts; ++i) {
            System.out.println("  Buf(" + i + ") = 0x" + Integer.toHexString(ibuf.get(i)));
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        try {
            this.flushToFile();
        }
        catch (EvioException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }
}

