/*
 * Decompiled with CFR 0.152.
 */
package org.jlab.coda.jevio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.BitSet;
import java.util.LinkedList;
import org.jlab.coda.jevio.BlockHeaderV4;
import org.jlab.coda.jevio.DataType;
import org.jlab.coda.jevio.EvioBank;
import org.jlab.coda.jevio.EvioEvent;
import org.jlab.coda.jevio.EvioException;
import org.jlab.coda.jevio.EvioReader;

public class EventWriter {
    static final int BLOCK_LENGTH_OFFSET = 0;
    static final int BLOCK_NUMBER_OFFSET = 4;
    static final int HEADER_LENGTH_OFFSET = 8;
    static final int EVENT_COUNT_OFFSET = 12;
    static final int RESERVED1_COUNT_OFFSET = 16;
    static final int BIT_INFO_OFFSET = 20;
    static final int MAGIC_OFFSET = 28;
    static final int VERSION_MASK = 255;
    static int DEFAULT_BLOCK_SIZE = 1024000;
    static int DEFAULT_BLOCK_COUNT = 10000;
    static int MAX_BLOCK_SIZE = 10240000;
    static int MAX_BLOCK_COUNT = 100000;
    static int MIN_BLOCK_SIZE = 100;
    static int MIN_BLOCK_COUNT = 1;
    private int blockSizeMax;
    private int blockCountMax;
    private int blockNumber;
    private int holdingListTotalBytes;
    private String xmlDictionary;
    private boolean writeDictionary;
    private BitSet bitInfo;
    private boolean closed;
    private boolean toFile;
    private boolean append;
    private boolean lastBlockOut;
    private int reserved1;
    private int reserved2;
    private int initialPosition;
    private int eventsWritten;
    private ByteBuffer emptyLastHeader;
    private ByteOrder byteOrder;
    private FileOutputStream fileOutputStream;
    private FileChannel fileChannel;
    private ByteBuffer blockBuffer;
    private LinkedList<ByteBuffer> eventBufferHoldingList = new LinkedList();
    private ByteBuffer buffer;
    private int bufferHeaderPosition;
    private LinkedList<EvioBank> eventHoldingList = new LinkedList();

    public EventWriter(File file) throws EvioException {
        this(file, false);
    }

    public EventWriter(File file, boolean append) throws EvioException {
        this(file, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, ByteOrder.nativeOrder(), null, null, true, append);
    }

    public EventWriter(File file, String dictionary, boolean append) throws EvioException {
        this(file, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, ByteOrder.nativeOrder(), dictionary, null, true, append);
    }

    public EventWriter(String filename) throws EvioException {
        this(filename, false);
    }

    public EventWriter(String filename, boolean append) throws EvioException {
        this(new File(filename), DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, ByteOrder.nativeOrder(), null, null, true, append);
    }

    public EventWriter(String filename, boolean append, ByteOrder byteOrder) throws EvioException {
        this(new File(filename), DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, byteOrder, null, null, true, append);
    }

    public EventWriter(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo) throws EvioException {
        this(file, blockSizeMax, blockCountMax, byteOrder, xmlDictionary, bitInfo, true, false);
    }

    public EventWriter(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK) throws EvioException {
        this(file, blockSizeMax, blockCountMax, byteOrder, xmlDictionary, bitInfo, overWriteOK, false);
    }

    public EventWriter(File file, int blockSizeMax, int blockCountMax, ByteOrder byteOrder, String xmlDictionary, BitSet bitInfo, boolean overWriteOK, boolean append) throws EvioException {
        if (blockSizeMax < MIN_BLOCK_SIZE || blockSizeMax > MAX_BLOCK_SIZE) {
            throw new EvioException("Block size arg must be bigger or smaller");
        }
        if (blockCountMax < MIN_BLOCK_COUNT || blockCountMax > MAX_BLOCK_COUNT) {
            throw new EvioException("Block count arg must be bigger or smaller");
        }
        if (file == null) {
            throw new EvioException("Null file arg");
        }
        if (byteOrder == null) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        this.toFile = true;
        this.append = append;
        this.byteOrder = byteOrder;
        this.blockSizeMax = blockSizeMax;
        this.blockCountMax = blockCountMax;
        this.xmlDictionary = xmlDictionary;
        this.blockNumber = 1;
        this.emptyLastHeader = ByteBuffer.allocate(32);
        this.emptyLastHeader.order(byteOrder);
        this.emptyLastHeader.putInt(0, 8);
        this.emptyLastHeader.putInt(4, 1);
        this.emptyLastHeader.putInt(8, 8);
        this.emptyLastHeader.putInt(12, 0);
        this.emptyLastHeader.putInt(20, 516);
        this.emptyLastHeader.putInt(28, -1059454720);
        this.bitInfo = bitInfo != null ? (BitSet)bitInfo.clone() : new BitSet(24);
        if (xmlDictionary != null) {
            if (append) {
                throw new EvioException("Cannot specify dictionary when appending");
            }
            this.bitInfo.set(0, true);
            this.writeDictionary = true;
        }
        if (!overWriteOK && !append && file.exists() && file.isFile()) {
            throw new EvioException("File exists but user requested no over-writing or appending, " + file.getPath());
        }
        try {
            if (append) {
                RandomAccessFile raf = new RandomAccessFile(file, "rw");
                this.fileChannel = raf.getChannel();
                this.buffer = ByteBuffer.allocate(32);
                this.examineFirstBufferHeader();
                if (this.byteOrder != byteOrder) {
                    this.emptyLastHeader.clear();
                    this.emptyLastHeader.order(this.byteOrder);
                    this.emptyLastHeader.putInt(0, 8);
                    this.emptyLastHeader.putInt(4, 1);
                    this.emptyLastHeader.putInt(8, 8);
                    this.emptyLastHeader.putInt(12, 0);
                    this.emptyLastHeader.putInt(20, 516);
                    this.emptyLastHeader.putInt(28, -1059454720);
                }
                this.toAppendPosition();
                this.getCleanBuffer(0, 0, false);
            } else {
                this.fileOutputStream = new FileOutputStream(file, append);
                this.fileChannel = this.fileOutputStream.getChannel();
                this.getCleanBuffer(0, 0, true);
            }
        }
        catch (FileNotFoundException e) {
            throw new EvioException("File could not be opened for writing, " + file.getPath(), e);
        }
        catch (IOException e) {
            throw new EvioException("File could not be positioned for appending, " + file.getPath(), e);
        }
    }

    public EventWriter(ByteBuffer buf) throws EvioException {
        this(buf, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, null, null, 0, false);
    }

    public EventWriter(ByteBuffer buf, boolean append) throws EvioException {
        this(buf, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, null, null, 0, append);
    }

    public EventWriter(ByteBuffer buf, String xmlDictionary, boolean append) throws EvioException {
        this(buf, DEFAULT_BLOCK_SIZE, DEFAULT_BLOCK_COUNT, xmlDictionary, null, 0, append);
    }

    public EventWriter(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo) throws EvioException {
        this(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, 0, false);
    }

    public EventWriter(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, boolean append) throws EvioException {
        this(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, 0, append);
    }

    public EventWriter(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1) throws EvioException {
        this(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, reserved1, false);
    }

    private EventWriter(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, boolean append) throws EvioException {
        this.initializeBuffer(buf, blockSizeMax, blockCountMax, xmlDictionary, bitInfo, reserved1, append);
    }

    private void initializeBuffer(ByteBuffer buf, int blockSizeMax, int blockCountMax, String xmlDictionary, BitSet bitInfo, int reserved1, boolean append) throws EvioException {
        if (blockSizeMax < MIN_BLOCK_SIZE) {
            throw new EvioException("Max block size arg (" + blockSizeMax + ") must be >= " + MIN_BLOCK_SIZE);
        }
        if (blockSizeMax > MAX_BLOCK_SIZE) {
            throw new EvioException("Max block size arg (" + blockSizeMax + ") must be <= " + MAX_BLOCK_SIZE);
        }
        if (blockCountMax < MIN_BLOCK_COUNT) {
            throw new EvioException("Max block count arg (" + blockCountMax + ") must be >= " + MIN_BLOCK_COUNT);
        }
        if (blockCountMax > MAX_BLOCK_COUNT) {
            throw new EvioException("Max block count arg (" + blockCountMax + ") must be <= " + MAX_BLOCK_COUNT);
        }
        if (buf == null) {
            throw new EvioException("Buffer arg cannot be null");
        }
        this.append = append;
        this.buffer = buf;
        this.byteOrder = buf.order();
        this.reserved1 = reserved1;
        this.blockSizeMax = blockSizeMax;
        this.blockCountMax = blockCountMax;
        this.xmlDictionary = xmlDictionary;
        this.toFile = false;
        this.closed = false;
        this.blockNumber = 1;
        this.eventsWritten = 0;
        this.holdingListTotalBytes = 0;
        this.eventHoldingList.clear();
        this.bufferHeaderPosition = this.initialPosition = buf.position();
        this.bitInfo = bitInfo != null ? (BitSet)bitInfo.clone() : new BitSet(24);
        if (xmlDictionary != null) {
            if (append) {
                throw new EvioException("Cannot specify dictionary when appending");
            }
            this.bitInfo.set(0, true);
            this.writeDictionary = true;
        }
        this.emptyLastHeader = ByteBuffer.allocate(32);
        this.emptyLastHeader.order(this.byteOrder);
        this.emptyLastHeader.putInt(0, 8);
        this.emptyLastHeader.putInt(4, 1);
        this.emptyLastHeader.putInt(8, 8);
        this.emptyLastHeader.putInt(12, 0);
        this.emptyLastHeader.putInt(20, 516);
        this.emptyLastHeader.putInt(28, -1059454720);
        try {
            if (append) {
                this.examineFirstBufferHeader();
                if (this.byteOrder != buf.order()) {
                    this.emptyLastHeader.clear();
                    this.emptyLastHeader.order(this.byteOrder);
                    this.emptyLastHeader.putInt(0, 8);
                    this.emptyLastHeader.putInt(4, 1);
                    this.emptyLastHeader.putInt(8, 8);
                    this.emptyLastHeader.putInt(12, 0);
                    this.emptyLastHeader.putInt(20, 516);
                    this.emptyLastHeader.putInt(28, -1059454720);
                }
                this.toAppendPosition();
            }
        }
        catch (IOException e) {
            throw new EvioException("Buffer could not be positioned for appending", e);
        }
    }

    public void setBuffer(ByteBuffer buf) throws EvioException {
        if (this.toFile) {
            return;
        }
        if (!this.closed) {
            throw new EvioException("close EventWriter before changing buffers");
        }
        this.initializeBuffer(buf, this.blockSizeMax, this.blockCountMax, this.xmlDictionary, this.bitInfo, this.reserved1, this.append);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public int getEventsWritten() {
        return this.eventsWritten;
    }

    public void setStartingBlockNumber(int startingBlockNumber) {
        if (this.eventsWritten > 0) {
            return;
        }
        this.blockNumber = startingBlockNumber;
    }

    public void close() throws EvioException, IOException {
        if (this.toFile) {
            this.closeFile();
        } else {
            this.closeBuffer();
        }
    }

    public void writeEvent(EvioBank bank) throws EvioException, IOException {
        if (bank == null) {
            throw new EvioException("Attempt to write null bank using EventWriter");
        }
        if (this.toFile) {
            this.writeEventToFile(bank);
        } else {
            this.writeEventToBuffer(bank);
        }
    }

    private void getCleanBuffer(int size, int eventCount, boolean incBlkNum) {
        if (this.blockBuffer == null) {
            int initialSize = size < 4 * this.blockSizeMax ? 4 * this.blockSizeMax : size;
            this.blockBuffer = ByteBuffer.allocate(initialSize);
            this.blockBuffer.order(this.byteOrder);
        } else {
            if (size > this.blockBuffer.capacity()) {
                this.blockBuffer = ByteBuffer.allocate(size + 100000);
                this.blockBuffer.order(this.byteOrder);
            }
            this.blockBuffer.clear();
        }
        this.blockBuffer.putInt(size / 4);
        this.blockBuffer.putInt(this.blockNumber);
        this.blockBuffer.putInt(8);
        this.blockBuffer.putInt(eventCount);
        this.blockBuffer.putInt(this.reserved1);
        this.blockBuffer.putInt(BlockHeaderV4.generateSixthWord(this.bitInfo));
        this.blockBuffer.putInt(this.reserved2);
        this.blockBuffer.putInt(-1059454720);
        if (incBlkNum) {
            ++this.blockNumber;
        }
    }

    protected synchronized IOStatus examineFirstBufferHeader() throws IOException, EvioException {
        int currentPosition;
        if (!this.append) {
            throw new EvioException("need to be in append mode");
        }
        if (this.toFile) {
            this.buffer.clear();
            int nBytes = this.fileChannel.read(this.buffer);
            if (nBytes != 32) {
                throw new EvioException("bad file format");
            }
            currentPosition = 0;
            this.fileChannel.position(0L);
        } else {
            if (this.buffer.remaining() < 32) {
                return IOStatus.END_OF_FILE;
            }
            currentPosition = this.buffer.position();
        }
        try {
            int bitInfo;
            int evioVersion;
            this.byteOrder = this.buffer.order();
            int magicNumber = this.buffer.getInt(currentPosition + 28);
            if (magicNumber != -1059454720) {
                this.byteOrder = this.byteOrder == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                this.buffer.order(this.byteOrder);
                magicNumber = this.buffer.getInt(currentPosition + 28);
                if (magicNumber != -1059454720) {
                    System.out.println("ERROR: reread magic # (" + magicNumber + ") & still not right");
                    return IOStatus.EVIO_EXCEPTION;
                }
            }
            if ((evioVersion = (bitInfo = this.buffer.getInt(currentPosition + 20)) & 0xFF) < 4) {
                System.out.println("ERROR: evio version# = " + evioVersion);
                return IOStatus.EVIO_EXCEPTION;
            }
        }
        catch (BufferUnderflowException a) {
            System.err.println("ERROR endOfBuffer " + a);
            return IOStatus.UNKNOWN_ERROR;
        }
        return IOStatus.SUCCESS;
    }

    private void toAppendPosition() throws EvioException, IOException {
        int headerLength;
        int blockLength;
        int bitInfo;
        int nBytes;
        if (!this.append) {
            throw new EvioException("need to be in append mode");
        }
        this.blockNumber = 1;
        while (true) {
            int currentPosition;
            if (this.toFile) {
                this.buffer.clear();
                nBytes = this.fileChannel.read(this.buffer);
                if (nBytes != 32) {
                    throw new EvioException("bad file format");
                }
                currentPosition = 0;
            } else {
                if (this.buffer.remaining() < 32) {
                    throw new EvioException("bad buffer format");
                }
                currentPosition = this.buffer.position();
            }
            bitInfo = this.buffer.getInt(currentPosition + 20);
            blockLength = this.buffer.getInt(currentPosition + 0);
            int blockNum = this.buffer.getInt(currentPosition + 4);
            headerLength = this.buffer.getInt(currentPosition + 8);
            int blockEventCount = this.buffer.getInt(currentPosition + 12);
            boolean lastBlock = BlockHeaderV4.isLastBlock(bitInfo);
            this.eventsWritten += blockEventCount;
            ++this.blockNumber;
            if (lastBlock) break;
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() + (long)(4 * blockLength) - 32L);
                continue;
            }
            if (this.buffer.remaining() < 4 * blockLength) {
                throw new EvioException("bad buffer format");
            }
            this.buffer.position(this.buffer.position() + 4 * blockLength);
        }
        if (blockLength > headerLength) {
            bitInfo = BlockHeaderV4.clearLastBlockBit(bitInfo);
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() - 12L);
                this.buffer.clear();
                this.buffer.putInt(bitInfo);
                this.buffer.flip();
                nBytes = this.fileChannel.write(this.buffer);
                if (nBytes != 4) {
                    throw new EvioException("file writing error");
                }
                this.fileChannel.position(this.fileChannel.position() + (long)(4 * blockLength) - 21L);
            } else {
                this.buffer.putInt(this.buffer.position() + 20, bitInfo);
                this.buffer.position(this.buffer.position() + 4 * blockLength);
            }
        } else {
            --this.blockNumber;
            if (this.toFile) {
                this.fileChannel.position(this.fileChannel.position() - 32L);
            }
        }
        if (!this.toFile && this.buffer.remaining() < 32) {
            throw new EvioException("bad buffer format");
        }
        this.writeEmptyLastBlockHeader(this.blockNumber);
    }

    private synchronized void closeFileOrig() throws IOException {
        int headerBytes;
        int requiredBufferByteSize = headerBytes = 32;
        if (this.eventBufferHoldingList.size() > 0) {
            requiredBufferByteSize = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.getCleanBuffer(requiredBufferByteSize, this.eventBufferHoldingList.size() - 1, true);
                this.updateBitInfo(BlockHeaderV4.generateSixthWord(this.bitInfo, true, true));
                this.bitInfo.set(0, false);
            } else {
                this.getCleanBuffer(requiredBufferByteSize, this.eventBufferHoldingList.size(), true);
                this.updateBitInfo(BlockHeaderV4.generateSixthWord(this.bitInfo, false, true));
            }
            this.writeDictionary = false;
            for (ByteBuffer buf : this.eventBufferHoldingList) {
                this.blockBuffer.put(buf);
            }
        } else {
            this.getCleanBuffer(headerBytes, 0, true);
            this.updateBitInfo(BlockHeaderV4.generateSixthWord(this.bitInfo, false, true));
        }
        this.fileOutputStream.write(this.blockBuffer.array(), 0, requiredBufferByteSize);
        this.fileOutputStream.flush();
        this.fileOutputStream.close();
        this.closed = true;
    }

    private synchronized void closeFile() throws IOException {
        int headerBytes = 32;
        if (this.eventBufferHoldingList.size() > 0) {
            int requiredBufferByteSize = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.getCleanBuffer(requiredBufferByteSize, this.eventBufferHoldingList.size() - 1, true);
                this.updateBitInfo(BlockHeaderV4.generateSixthWord(this.bitInfo, true, false));
                this.bitInfo.set(0, false);
            } else {
                this.getCleanBuffer(requiredBufferByteSize, this.eventBufferHoldingList.size(), true);
                this.updateBitInfo(BlockHeaderV4.generateSixthWord(this.bitInfo, false, false));
            }
            this.writeDictionary = false;
            for (ByteBuffer buf : this.eventBufferHoldingList) {
                this.blockBuffer.put(buf);
            }
            this.blockBuffer.flip();
            this.fileChannel.write(this.blockBuffer);
            this.writeEmptyLastBlockHeader(this.blockNumber);
        } else if (!this.lastBlockOut) {
            this.writeEmptyLastBlockHeader(this.blockNumber);
        }
        this.fileChannel.close();
        this.closed = true;
    }

    private synchronized void writeEventToFileOrig(EvioBank bank) throws IOException {
        int requiredBufferBytes;
        if (this.closed) {
            throw new IOException("file was closed");
        }
        boolean gotDictionary = false;
        if (this.blockBuffer == null) {
            this.getCleanBuffer(0, 0, true);
            if (this.xmlDictionary != null) {
                gotDictionary = true;
                this.writeDictionary = true;
            }
        }
        int currentEventBytes = bank.getTotalBytes();
        ByteBuffer currentEventBuffer = ByteBuffer.allocate(currentEventBytes);
        currentEventBuffer.order(this.byteOrder);
        bank.write(currentEventBuffer);
        currentEventBuffer.position(0);
        int headerBytes = 32;
        int roomForData = 4 * this.blockSizeMax - headerBytes;
        if (gotDictionary) {
            EvioBank dictBank = new EvioBank(0, DataType.CHARSTAR8, 0);
            try {
                dictBank.appendStringData(this.xmlDictionary);
            }
            catch (EvioException e) {
                // empty catch block
            }
            int dictEventBytes = dictBank.getTotalBytes();
            ByteBuffer dictEventBuffer = ByteBuffer.allocate(dictEventBytes);
            dictEventBuffer.order(this.byteOrder);
            dictBank.write(dictEventBuffer);
            dictEventBuffer.position(0);
            this.eventBufferHoldingList.addFirst(dictEventBuffer);
            this.holdingListTotalBytes += dictEventBytes;
        }
        if (this.eventBufferHoldingList.size() > 0 && this.holdingListTotalBytes + currentEventBytes > roomForData) {
            requiredBufferBytes = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.getCleanBuffer(requiredBufferBytes, this.eventBufferHoldingList.size() - 1, true);
                this.bitInfo.set(0, false);
            } else {
                this.getCleanBuffer(requiredBufferBytes, this.eventBufferHoldingList.size(), true);
            }
            for (ByteBuffer buf : this.eventBufferHoldingList) {
                this.blockBuffer.put(buf);
            }
            this.fileOutputStream.write(this.blockBuffer.array(), 0, requiredBufferBytes);
            this.writeDictionary = false;
            this.eventBufferHoldingList.clear();
            this.holdingListTotalBytes = 0;
        }
        if (currentEventBytes >= roomForData) {
            requiredBufferBytes = currentEventBytes + headerBytes;
            this.getCleanBuffer(requiredBufferBytes, 1, true);
            this.blockBuffer.put(currentEventBuffer);
        } else {
            this.eventBufferHoldingList.add(currentEventBuffer);
            this.holdingListTotalBytes += currentEventBytes;
            if (this.eventBufferHoldingList.size() < this.blockCountMax) {
                return;
            }
            requiredBufferBytes = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.getCleanBuffer(requiredBufferBytes, this.eventBufferHoldingList.size() - 1, true);
                this.bitInfo.set(0, false);
            } else {
                this.getCleanBuffer(requiredBufferBytes, this.eventBufferHoldingList.size(), true);
            }
            for (ByteBuffer buf : this.eventBufferHoldingList) {
                this.blockBuffer.put(buf);
            }
        }
        this.fileOutputStream.write(this.blockBuffer.array(), 0, requiredBufferBytes);
        this.writeDictionary = false;
        this.eventBufferHoldingList.clear();
        this.holdingListTotalBytes = 0;
    }

    private synchronized void writeEventToFile(EvioBank bank) throws IOException {
        int requiredBufferBytes;
        if (this.closed) {
            throw new IOException("file was closed");
        }
        int currentEventBytes = bank.getTotalBytes();
        ByteBuffer currentEventBuffer = ByteBuffer.allocate(currentEventBytes);
        currentEventBuffer.order(this.byteOrder);
        bank.write(currentEventBuffer);
        currentEventBuffer.flip();
        int headerBytes = 32;
        int roomForData = 4 * this.blockSizeMax - headerBytes;
        if (this.writeDictionary && this.eventsWritten < 1) {
            EvioBank dictBank = new EvioBank(0, DataType.CHARSTAR8, 0);
            try {
                dictBank.appendStringData(this.xmlDictionary);
            }
            catch (EvioException e) {
                // empty catch block
            }
            int dictEventBytes = dictBank.getTotalBytes();
            ByteBuffer dictEventBuffer = ByteBuffer.allocate(dictEventBytes);
            dictEventBuffer.order(this.byteOrder);
            dictBank.write(dictEventBuffer);
            dictEventBuffer.position(0);
            this.eventBufferHoldingList.addFirst(dictEventBuffer);
            this.holdingListTotalBytes += dictEventBytes;
        }
        if (this.eventBufferHoldingList.size() > 0 && this.holdingListTotalBytes + currentEventBytes > roomForData) {
            requiredBufferBytes = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.getCleanBuffer(requiredBufferBytes, this.eventBufferHoldingList.size() - 1, true);
                this.bitInfo.set(0, false);
            } else {
                this.getCleanBuffer(requiredBufferBytes, this.eventBufferHoldingList.size(), true);
            }
            for (ByteBuffer buf : this.eventBufferHoldingList) {
                this.blockBuffer.put(buf);
            }
            this.blockBuffer.flip();
            this.fileChannel.write(this.blockBuffer);
            this.writeDictionary = false;
            this.eventBufferHoldingList.clear();
            this.holdingListTotalBytes = 0;
        }
        if (currentEventBytes >= roomForData) {
            requiredBufferBytes = currentEventBytes + headerBytes;
            this.getCleanBuffer(requiredBufferBytes, 1, true);
            this.blockBuffer.put(currentEventBuffer);
        } else {
            this.eventBufferHoldingList.add(currentEventBuffer);
            this.holdingListTotalBytes += currentEventBytes;
            if (this.eventBufferHoldingList.size() < this.blockCountMax) {
                ++this.eventsWritten;
                return;
            }
            requiredBufferBytes = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.getCleanBuffer(requiredBufferBytes, this.eventBufferHoldingList.size() - 1, true);
                this.bitInfo.set(0, false);
            } else {
                this.getCleanBuffer(requiredBufferBytes, this.eventBufferHoldingList.size(), true);
            }
            for (ByteBuffer buf : this.eventBufferHoldingList) {
                this.blockBuffer.put(buf);
            }
        }
        this.blockBuffer.flip();
        this.fileChannel.write(this.blockBuffer);
        this.writeEmptyLastBlockHeader(this.blockNumber);
        ++this.eventsWritten;
        this.writeDictionary = false;
        this.eventBufferHoldingList.clear();
        this.holdingListTotalBytes = 0;
    }

    private void writeEmptyLastBlockHeader(int blockNum) throws IOException {
        this.emptyLastHeader.putInt(4, blockNum);
        if (this.toFile) {
            long originalPosition = this.fileChannel.position();
            this.fileChannel.write(this.emptyLastHeader);
            this.fileChannel.position(originalPosition);
        } else {
            int originalPosition = this.buffer.position();
            this.buffer.put(this.emptyLastHeader);
            this.buffer.position(originalPosition);
        }
        this.emptyLastHeader.position(0);
        this.lastBlockOut = true;
    }

    private void writeNewHeader(int size, int eventCount) throws EvioException {
        if (this.buffer.remaining() < 32) {
            throw new EvioException("Buffer size exceeded");
        }
        this.bufferHeaderPosition = this.buffer.position();
        this.buffer.putInt(size / 4);
        this.buffer.putInt(this.blockNumber++);
        this.buffer.putInt(8);
        this.buffer.putInt(eventCount);
        this.buffer.putInt(this.reserved1);
        this.buffer.putInt(BlockHeaderV4.generateSixthWord(this.bitInfo));
        this.buffer.putInt(this.reserved2);
        this.buffer.putInt(-1059454720);
    }

    private synchronized void closeBuffer() throws EvioException {
        int headerBytes = 32;
        if (this.eventHoldingList.size() > 0) {
            int requiredBufferByteSize = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.writeNewHeader(requiredBufferByteSize, this.eventHoldingList.size() - 1);
                this.updateBitInfoInBuffer(BlockHeaderV4.generateSixthWord(this.bitInfo, true, false));
                this.bitInfo.set(0, false);
            } else {
                this.writeNewHeader(requiredBufferByteSize, this.eventHoldingList.size());
                this.updateBitInfoInBuffer(BlockHeaderV4.generateSixthWord(this.bitInfo, false, false));
            }
            this.writeDictionary = false;
            for (EvioBank bnk : this.eventHoldingList) {
                bnk.write(this.buffer);
            }
            try {
                this.writeEmptyLastBlockHeader(this.blockNumber);
            }
            catch (IOException iOException) {}
        } else if (!this.lastBlockOut) {
            try {
                this.writeEmptyLastBlockHeader(this.blockNumber);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.buffer.position(this.buffer.position() + headerBytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    private synchronized void writeEventToBuffer(EvioBank bank) throws EvioException {
        int requiredBufferBytes;
        if (this.closed) {
            throw new EvioException("close() has already been called");
        }
        if (this.writeDictionary && this.eventsWritten < 1) {
            EvioBank dictBank = new EvioBank(0, DataType.CHARSTAR8, 0);
            try {
                dictBank.appendStringData(this.xmlDictionary);
            }
            catch (EvioException e) {
                // empty catch block
            }
            int dictEventBytes = dictBank.getTotalBytes();
            this.eventHoldingList.addFirst(dictBank);
            this.holdingListTotalBytes += dictEventBytes;
        }
        int currentEventBytes = bank.getTotalBytes();
        int headerBytes = 32;
        int roomForData = 4 * this.blockSizeMax - headerBytes;
        if (this.eventHoldingList.size() > 0 && this.holdingListTotalBytes + currentEventBytes > roomForData) {
            requiredBufferBytes = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.writeNewHeader(requiredBufferBytes, this.eventHoldingList.size() - 1);
                this.bitInfo.set(0, false);
            } else {
                this.writeNewHeader(requiredBufferBytes, this.eventHoldingList.size());
            }
            for (EvioBank bnk : this.eventHoldingList) {
                bnk.write(this.buffer);
            }
            this.writeDictionary = false;
            this.eventHoldingList.clear();
            this.holdingListTotalBytes = 0;
        }
        if (currentEventBytes >= roomForData) {
            requiredBufferBytes = currentEventBytes + headerBytes;
            this.writeNewHeader(requiredBufferBytes, 1);
            bank.write(this.buffer);
        } else {
            this.eventHoldingList.add(bank);
            this.holdingListTotalBytes += currentEventBytes;
            if (this.eventHoldingList.size() < this.blockCountMax) {
                ++this.eventsWritten;
                return;
            }
            requiredBufferBytes = this.holdingListTotalBytes + headerBytes;
            if (this.writeDictionary) {
                this.writeNewHeader(requiredBufferBytes, this.eventHoldingList.size() - 1);
                this.bitInfo.set(0, false);
            } else {
                this.writeNewHeader(requiredBufferBytes, this.eventHoldingList.size());
            }
            for (EvioBank bnk : this.eventHoldingList) {
                bnk.write(this.buffer);
            }
        }
        ++this.eventsWritten;
        this.writeDictionary = false;
        this.eventHoldingList.clear();
        this.holdingListTotalBytes = 0;
    }

    private void updateBitInfo(int word) {
        this.blockBuffer.putInt(20, word);
    }

    private void updateBitInfoInBuffer(int word) {
        this.buffer.putInt(this.bufferHeaderPosition + 20, word);
    }

    public static void mainOrig(String[] args) {
        String infile = "../../testdata/out.ev";
        String outfile = "../../testdata/out_copy.ev";
        int count = 0;
        try {
            EvioEvent event;
            EvioReader inFile = new EvioReader(new File(infile));
            EventWriter eventWriter = new EventWriter(new File(outfile));
            while ((event = inFile.parseNextEvent()) != null) {
                eventWriter.writeEvent(event);
                ++count;
            }
            eventWriter.close();
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("copied: " + count + " events.");
        EvioReader.compareEventFiles(new File(infile), new File(outfile));
    }

    public static void main(String[] args) {
        String infile = "/daqfs/home/timmer/coda/jevio-4.0/testdata/out.ev";
        String outfile = "/tmp/out_copy.ev";
        int count = 0;
        try {
            EvioReader inFile = new EvioReader(new File(infile));
            int eventCount = inFile.getEventCount();
            System.out.println("eventCount = " + eventCount);
            EvioEvent[] event = new EvioEvent[eventCount + 1];
            while ((event[count++] = inFile.parseNextEvent()) != null) {
            }
            long tTotal = 0L;
            for (int i = 0; i < 40; ++i) {
                EventWriter eventWriter = new EventWriter(new File(outfile));
                long t1 = System.currentTimeMillis();
                for (int j = 0; j < eventCount; ++j) {
                    eventWriter.writeEvent(event[i]);
                }
                eventWriter.close();
                long t2 = System.currentTimeMillis();
                tTotal += t2 - t1;
            }
            System.out.println("time (ms): " + tTotal);
        }
        catch (EvioException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        EvioReader.compareEventFiles(new File(infile), new File(outfile));
    }

    public static enum IOStatus {
        SUCCESS,
        END_OF_FILE,
        EVIO_EXCEPTION,
        CANNOT_OPEN_FILE,
        UNKNOWN_ERROR;

    }
}

