#include <cdevDirectoryTool.h>

int main ( int argc, char ** argv )
	{
	int    result     = 0;
	char * inputFile  = NULL;
	char * outputFile = NULL;	

	for(int i=1; i<argc; i++)
		{
		if(!strcmp(argv[i], "-o")) outputFile = argv[++i];
		else                       inputFile = argv[i];
		}
	
	if(inputFile==NULL || outputFile==NULL)
		{
		fprintf(stdout, "\nbin2Ascii Error:\n  => Bad or missing arguments\n  => Format is: bin2Ascii inputFile -o outputFile\n");
		result = -1;
		}
	else	{
		cdevDirectoryTable table;
		FILE * fp;
		
		fprintf(stdout, "bin2Ascii: Converting %s to %s\n", inputFile, outputFile);
		fflush (stdout);

		if(table.load (inputFile)==CDEV_SUCCESS && (fp=fopen(outputFile, "w"))!=NULL) 
			{
			table.asciiDump(fp);
			fclose(fp);
			}
		}

	return result;
	}
