#include <cdevDirectoryTool.h>

int main ( int argc, char ** argv )
	{
	int    result     = 0;
	char * inputFile  = NULL;
	char * outputFile = NULL;	

	for(int i=1; i<argc; i++)
		{
		if(!strcmp(argv[i], "-o")) outputFile = argv[++i];
		else                       inputFile = argv[i];
		}
	
	if(inputFile==NULL || outputFile==NULL)
		{
		fprintf(stdout, "ascii2Bin Error:\n  => Bad or missing arguments\n  => Format is: ascii2Bin inputFile -o outputFile\n");
		result = -1;
		}
	else	{
		cdevDirectoryTable table;

		fprintf(stdout, "\nascii2Bin: Compiling %s to %s\n", inputFile, outputFile);
		fflush (stdout);

		if(table.load (inputFile)==CDEV_SUCCESS) table.binaryDump(outputFile);
		}

	return result;
	}
