#include <cdevData.h>

void scalarTest( void ) 
	{
	cdevData data1;
	
	data1.insert(1, (unsigned char)1);
	data1.insert(2, (short)2);
	data1.insert(3, (unsigned short)3);
	data1.insert(4, (int) 4);
	data1.insert(5, (unsigned int) 5);
	data1.insert(6, (float) 6.0);
	data1.insert(7, (double) 7.0);
	data1.insert(8, "This is a test");
	
	cdevData data2 (data1);
	cdevData data3 (data1);
	cdevData data4 (data1);
	cdevData data5 (data1);
	cdevData data6;
	cdevData data7;
	
		
	data3.insert(8, "This was a test");
	data4.remove(1);
	data5.insert(1, (int)1);
	data6 = data1;
	data7.insert(9, "Test");
	
	fprintf(stdout, "SCALAR TEST\n");
	fprintf(stdout, "Data 1 %s equal to Data 2 - should be equal...\n", data1==data2?"IS":"IS NOT");
	fprintf(stdout, "Data 1 %s equal to Data 3 - should NOT be equal...\n", data1==data3?"IS":"IS NOT");
	fprintf(stdout, "Data 1 %s equal to Data 4 - should NOT be equal...\n", data1==data4?"IS":"IS NOT");
	fprintf(stdout, "Data 1 %s equal to Data 5 - should NOT be equal...\n", data1==data5?"IS":"IS NOT");
	fprintf(stdout, "Data 1 %s equal to Data 6 - should be equal...\n", data1==data6?"IS":"IS NOT");
	fprintf(stdout, "Data 1 %s equal to Data 7 - should NOT be equal...\n", data1==data7?"IS":"IS NOT");
	fprintf(stdout, "\n");
	}

int           array1[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
unsigned char array2[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
char      *   array3[] = {
	"This is a test", 
	"This is a test 2",
	"This is a test 3",
	"This is a test 4"
	};
	         
cdevBounds bounds1[2] =
	{
	{0, 1},{0, 4}  
	};

cdevBounds bounds2[2] =
	{
	{0, 1},{0, 2}
	};
	
void vectorTest ( void )
	{
	cdevData data1;
	
	data1.insert(1, array1, 10);
	data1.insert(2, array2, 10);
	data1.insert(3, array3, 4);
	
	cdevData data2 (data1);

	fprintf(stdout, "---------------------------------\n");
	fprintf(stdout, "Diagnostic Dump of cdevData data1\n");
	fprintf(stdout, "---------------------------------\n");
	data1.asciiDump();
	fprintf(stdout, "---------------------------------\n");

	fprintf(stdout, "---------------------------------\n");
	fprintf(stdout, "Diagnostic Dump of cdevData data2\n");
	fprintf(stdout, "---------------------------------\n");
	data2.asciiDump();
	fprintf(stdout, "---------------------------------\n");

	fprintf(stdout, "ARRAY TEST\n");
	fprintf(stdout, "Data 1 %s equal to Data 2 - should be equal...\n", data1==data2?"IS":"IS NOT");
	fprintf(stdout, "\n");			
	}

int main()
	{
	scalarTest();
	vectorTest();
	}
	
