//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cdevFdServive (Arbitrary user file descriptor service)
//
// Author:  Jie Chen
//
// Revision History:
//   cdevUserFdService.h,v
// Revision 1.1  1997/02/18  15:45:48  chen
// port to linux 2.0.x + addUserFdCallback
//
//
// 
#ifndef _CDEV_USER_FD_SERVICE_H
#define _CDEV_USER_FD_SERVICE_H

#include <cdevService.h>

class cdevUserFdService: public cdevService
{
public:
  cdevUserFdService (int fd, cdevUserFdCallback cbk, void* arg,
		     char* name,
		     cdevSystem& system = cdevSystem::defaultSystem ()
		     );
  // PURPOSE: construction of fdService
  // REQUIRE: none
  // PROMISE: A fd servive with a unique name

  ~cdevUserFdService (void);
  // PURPOSE: destruction of fdService
  // REQUIRE: none
  // PROMISE: this object is gone forever

  int getFd (int* &fd, int &numFd);
  // PURPOSE: get service's IO file descriptors
  // REQUIRE: callers provide pointer (eg. int *fd = 0;) no memory. callers
  //          should never free memory pointed by fd. fd should be cached
  //          inside derived class for easy/quick access
  // PROMISE: numFd >= 0

  int getNameServer (cdevDevice* &server);
  // PURPOSE: get right name server associated with this service
  // REQUIRE: caller provide pointer only, derived class provides 
  //          an empty function for now
  // PROMISE: not implemented yet

  int flush (void);
  // PURPOSE: pure virtual function to define intreface for net flush
  // REQUIRE: derived class provide implementation
  // PROMISE: return CDEV_SUCCESS

  int poll  (void);
  // PURPOSE: pure virtual function to define intreface for polling method
  // REQUIRE: derived class provide implementation
  // PROMISE: return CDEV_SUCCESS: OK. return -1: network error

  int pend  (int fd = -1);
  // PURPOSR: pure virtual function to define interface for pending method
  // REQUIRE: derived class provide implementation
  // PROMISE: return CDEV_SUCCESS, OK, return -1: network error

  int pend  (double seconds, int fd = -1);
  // PURPOSR: pure virtual function to define interface for pending method
  // REQUIRE: derived class provide implementation
  // PROMISE: return CDEV_SUCCESS, OK, return CDEV_TIMEOUT: timeout.
  //          -1: network error

  static const char* prefixName (void);
  // PURPOSE: return common prefix name for all services
  // REQUIRE: none
  // PROMISE: return common prefix name

  const char *className (void) const {return "cdevUserFdService";}

protected:
  // hide request object creation method
  int getRequestObject (char *deviceName, 
			char *msg, 
			cdevRequestObject* &req);
  // PURPOSE: get request object: this service return 0
  // REQUIRE: callers provide pointer to cdevRequestObject only, no memory
  // PROMISE: nothing

private:
  // associated fd
  int* fd_;
  // user function and usr argument
  cdevUserFdCallback cbk_;
  void*              arg_;

  // unique name for fd services
  static const char* fdsvcname_;
};
#endif

 
