//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cdevUserFdService Class
//
// Author:  Jie Chen
//
// Revision History:
//   cdevUserFdService.cc,v
// Revision 1.2  1997/04/02  17:54:09  akers
// Ongoing Development of CDEV 1.6
//
// Revision 1.1  1997/02/18  15:45:47  chen
// port to linux 2.0.x + addUserFdCallback
//
//
// 
#include <cdevErrCode.h>
#include "cdevUserFdService.h"

const char* cdevUserFdService::fdsvcname_ = "fdsvcXXXXXX";

cdevUserFdService::cdevUserFdService (int fd, cdevUserFdCallback cbk,
				      void* arg,
				      char* name,
				      cdevSystem& system)
:cdevService (name, system), cbk_ (cbk), arg_ (arg)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cdevUserFdService Class Object: %s\n", name);
#endif
  fd_ = new int;
  *fd_ = fd;
}

cdevUserFdService::~cdevUserFdService (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cdevUserFdService Class Object: %s\n", serviceName_);
#endif
  // delete fd memory
  delete fd_;
}

int
cdevUserFdService::getFd (int* &fd, int &numFd)
{
  numFd = 1;
  fd = fd_;

  return CDEV_SUCCESS;
}

int
cdevUserFdService::getNameServer (cdevDevice* &server)
{
  server = 0;
  return CDEV_SUCCESS;
}

int
cdevUserFdService::flush (void)
{
  return CDEV_SUCCESS;
}

int
cdevUserFdService::poll (void)
{
  return (*cbk_)(1, *fd_, arg_);
}

int
cdevUserFdService::pend (int /* fd */ )
{
  return poll ();
}

int
cdevUserFdService::pend (double /* timeout */, int /* fd */)
{
  return poll ();
}

int 
cdevUserFdService::getRequestObject (char* /* deviceName */, char* /* msg */,
				     cdevRequestObject * &req)
{
  req = 0;
  return CDEV_ERROR;
}

const char*
cdevUserFdService::prefixName (void)
{
  return cdevUserFdService::fdsvcname_;
}
