//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cdevSerice class (Abstract class )
//
// Author:  Jie Chen, Chip Watson & Walt Akers
//
// Revision History:
//   cdevService.h,v
// Revision 1.3  1997/08/27  18:23:32  chen
// Change error reporting to site specific scheme
//
// Revision 1.2  1996/11/21  17:03:32  akers
// Ongoing Developement of CDEV 1.5
//
// Revision 1.1.1.1  1995/06/16  17:14:08  epics
// initial import of cdev
//
// 
#ifndef _CDEV_SERVICE_H
#define _CDEV_SERVICE_H

#include "cdevSystemBase.h"
#include "cdevSystem.h"

class cdevCollectionRequest;

class cdevDevice;

class CDEV_CLASS_SPEC cdevService: public cdevSystemBase
{
public:
  virtual int getFd (int* &fd, int &numFd) = 0;
  // PURPOSE: get service's IO file descriptors
  // REQUIRE: callers provide pointer (eg. int *fd = 0;) no memory. callers
  //          should never free memory pointed by fd. fd should be cached
  //          inside derived class for easy/quick access
  // PROMISE: numFd >= 0

  virtual int getNameServer (cdevDevice* &server) = 0;
  // PURPOSE: get right name server associated with this service
  // REQUIRE: caller provide pointer only, derived class provides 
  //          an empty function for now
  // PROMISE: not implemented yet

  virtual int registerFd (int fd, int opened = 1);
  // PURPOSE: updating file descriptor mask
  // REQUIRE: opend = 1 for adding, else removing
  // PROMISE: return 0

  virtual char *name (void) const;
  // PURPOSE: return name of this service
  // REQUIRE: name must be unique in one system
  // PROMISE: name

  virtual int getCollectionRequest (char ** devices, int nDevices, 
				    char * msg, cdevCollectionRequest * &req);
  // PURPOSE: return collection requestobject
  // REQUIRE: devices != NULL, ndevices > 0
  // PROMISE: CDEV_SUCCESS on success, CDEV_ERROR no request object

  const int version (void) const;
  // PURPOSE: return version of service
  // REQUIRE: none
  // PROMISE: version number of this service

  virtual const char *className (void) const {return "cdevService";}
  
protected:
  // constructor: deny access for direct instantiation
  cdevService (char *name, cdevSystem &system = cdevSystem::defaultSystem ());
  // destructor, all services must be created and destroyed by system 
  virtual ~cdevService (void);

  // data area
  cdevSystem     &system_;
  char           *serviceName_;
  // flag to tell whether one unregister itself from system
  int            unregOn_;
  // friend class decleration
  friend class   cdevSystem;
};
#endif

 
