//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       cdevSerice class (Abstract class )
//
// Author:  Jie Chen & Chip Watson
//
// Revision History:
//   cdevService.cc,v
// Revision 1.3  1997/08/27  18:23:31  chen
// Change error reporting to site specific scheme
//
// Revision 1.2  1996/11/21  17:03:30  akers
// Ongoing Developement of CDEV 1.5
//
// Revision 1.1.1.1  1995/06/16  17:14:08  epics
// initial import of cdev
//
// 
#include <stdio.h>
#include <string.h>
#include <cdevErrCode.h>
#include "cdevService.h"
#include "cdevDefCollectionRequest.h"

cdevService::cdevService (char *name, cdevSystem & system)
:cdevSystemBase(),system_(system)
{
#ifdef _TRACE_OBJECTS
  printf("              Create cdevService class object\n");
#endif
  serviceName_ = new char[::strlen(name) + 1];
  ::strcpy (serviceName_, name);
  unregOn_ = 1;
  system.registerService (this);
}

cdevService::~cdevService (void)
{
#ifdef _TRACE_OBJECTS
  printf("              Delete cdevService class object\n");
#endif
  delete []serviceName_;
  // system will clean this, depending on unregOn_ flag
  if (unregOn_)
    system_.removeService (this);
}

int 
cdevService::getCollectionRequest (char ** devices, int nDevices, 
				   char * msg, cdevCollectionRequest * &req)
{
  req = new cdevDefCollectionRequest(devices, nDevices, msg, system_);
  return (req==NULL)?CDEV_ERROR:CDEV_SUCCESS;
}
                                    
char *
cdevService::name (void) const
{
  return serviceName_;
}

int
cdevService::registerFd (int fd, int opened)
{
  if (opened){ // add to existing file mask
    system_.attachReadFd (fd);
  }
  else { // remove from the file mask
    system_.detachReadFd (fd);
  }
  return CDEV_SUCCESS;
}

const int
cdevService::version (void) const
{
  return CDEV_VERSION;
}

