//-----------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevService Error Handler Class
//
// Author:  Jie Chen
//
// Revision History:
//   cdevErrSvc.h,v
// Revision 1.1.1.1  1995/06/16  17:14:08  epics
// initial import of cdev
//
//
#ifndef _CDEV_ERR_SVC_H
#define _CDEV_ERR_SVC_H

#include "cdevService.h"

class cdevErrSvc: public cdevService
{
 public:
  cdevErrSvc (cdevSystem& system = cdevSystem::defaultSystem());
  // PURPOSE: constructor
  // REQUIRE: nothing
  // PROMISE: a cdevErrSvc 

  ~cdevErrSvc (void);
  // PURPOSE: Destructor
  // REQUIRE: nothing
  // PROMISE: free all memory

  int getFd (int * &fd, int &numFd);
  // PURPOSE: get service file descriptors
  // REQUIRE: callers provide no memory, caller don't free memory
  // PROMISE: numFd gives number of file descriptors, numFd >= 0

  int flush (void);
  // PURPOSE: flush network request
  // REQUIRE: nothing
  // PROMISE: return 0

  int poll (void);
  // PURPOSE: Service Polling Method
  // REQURIE: nothing
  // PROMISE: return 0

  int pend (int fd = -1);
  // PURPOSE: Service Pending Method
  // REQUIRE: nothing
  // PROMISE: return 0

  int pend (double seconds, int fd = -1);
  // PURPOSE: Service Pending Method For Upto 'seconds'
  // REQUIRE: nothing
  // PROMISE: return 0

  int getRequestObject (char *deviceName, char *msg,
			cdevRequestObject * &reqObj);
  // PURPOSE: get requestobject
  // REQUIRE: nothing
  // PROMISE: return 0, reqobj = 0;

  int getNameServer (cdevDevice * &ns);
  // PURPOSE: get name server
  // REQUIRE: nothing
  // PROMISE: return 0, ns = 0

  const char *className (void) const {return "cdevErrSvc";}
};
#endif
