/*
//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      CDEV error codes
//
// Author:  Jie Chen
//
// Revision History:
//   cdevErrCode.h,v
// Revision 1.8  1998/01/14  17:49:48  chen
// add msg error
//
// Revision 1.7  1998/01/14  13:47:10  chen
// add more status code
//
// Revision 1.6  1996/12/16  20:48:51  akers
// Support for additional cdevCallback features
//
// Revision 1.5  1996/11/21  17:03:29  akers
// Ongoing Developement of CDEV 1.5
//
// Revision 1.4  1995/10/17  17:33:57  akers
// Updated error, status, access and severity codes
//
// Revision 1.3  1995/10/03  20:07:13  chen
// add connection event type
//
// Revision 1.2  1995/07/05  18:44:05  chen
// change to C code callable style
//
// Revision 1.1.1.1  1995/06/16  17:14:08  epics
// initial import of cdev
//
//
*/
#ifndef _CDEV_ERROR_CODE_H
#define _CDEV_ERROR_CODE_H

/* Error and status values                                                 */
#define CDEV_WARNING       -2  /* Failure of function is non-consequential */
#define CDEV_ERROR         -1  /* Errors that are not in any categories    */
#define CDEV_SUCCESS        0  /* cdev success                             */
#define CDEV_INVALIDOBJ     1  /* invalid cdev objects                     */
#define CDEV_INVALIDARG     2  /* invalid argument passed to cdev calls    */
#define CDEV_INVALIDSVC     3  /* wrong service during dynamic loading     */
#define CDEV_INVALIDOP      4  /* operation is unsupported (collection)    */

#define CDEV_NOTCONNECTED   5  /* not connected to low network service     */
#define CDEV_IOFAILED       6  /* low level network service IO failed      */
#define CDEV_CONFLICT       7  /* conflicts of data types or tags          */
#define CDEV_NOTFOUND       8  /* cdev cannot find user request (cdevData) */

#define CDEV_TIMEOUT        9  /* time out                                 */
#define CDEV_CONVERT       10  /* cdevData conversion error                */
#define CDEV_OUTOFRANGE    11  /* value out of range for device attribute  */
#define CDEV_NOACCESS      12  /* insufficient access to perform request   */
#define CDEV_ACCESSCHANGED 13  /* change in access permission of device    */

#define CDEV_DISCONNECTED      60 /* channel has been disconnected         */
#define CDEV_RECONNECTED       61 /* channel has been reconnected          */

#define CDEV_DELETE_CALLBACK   70 /* the callback object will be deleted   */

/* status related to callback status and more                              */
#define CDEV_NOTCONSERVER   80 /* can not connect to server/ not connected */
#define CDEV_NOTFOUNDSERVER 81 /* can not find server                      */
#define CDEV_CONN_TIMEOUT   82 /* connection timeout                       */
#define CDEV_BADIO          86 /* TCP io is bad file descriptor            */
#define CDEV_OVERFLOW       87 /* overflow buffer                          */
#define CDEV_INCOMPLETE     88 /* data flow will coming (unfinished)       */
#define CDEV_CBK_FINISHED   89 /* callback finished (monitor off)          */
#define CDEV_PAUSED         90 /* callback is paused                       */
#define CDEV_MSG_ERR        91 /* query message syntax error               */

/* Request object state values                                             */
#define CDEV_STATE_CONNECTED    0 /* request object is connected to device */
#define CDEV_STATE_NOTCONNECTED 1 /* request object is not connected       */
#define CDEV_STATE_INVALID      2 /* request object is invalid             */

/* Request object access values                                            */
#define CDEV_ACCESS_NONE        0 /* no access to specified attribute      */
#define CDEV_ACCESS_READONLY    1 /* read-only access to attribute         */
#define CDEV_ACCESS_WRITE       2 /* read-write access to attribute        */

/* cdevError class severity codes                                          */
#define CDEV_SEVERITY_INFO      0 /* informative message                   */
#define CDEV_SEVERITY_WARN      1 /* warning message                       */
#define CDEV_SEVERITY_ERROR     2 /* error message                         */
#define CDEV_SEVERITY_SEVERE    3 /* severe or fatal error message         */

#endif
