//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      CDEV Configuration Loader for different site
//
// Author:  Jie Chen
//
// Revision History:
//   cdevConfigFinder.h,v
// Revision 1.1  1997/08/27  18:23:30  chen
// Change error reporting to site specific scheme
//
//
//
#ifndef _CDEV_CONFIG_FINDER_H
#define _CDEV_CONFIG_FINDER_H

#if defined (_WIN32)

#ifndef SHOBJ
#define SHOBJ 1
#endif

#endif  /* WIN 32 */

#ifdef SHOBJ

#include <stdio.h>
#include <string.h>
#include <cdevSystem.h>

#define _CDEV_CONFIG_FILENAME "cdevSiteConfig.so"
#define _CDEV_CONFIG_ROUTINE  "_cdev_site_config"

class shObjLoader;

class cdevConfigFinder
{
public:
  // constructor and destructor
  cdevConfigFinder  (cdevSystem& system = cdevSystem::defaultSystem ());
  ~cdevConfigFinder (void);
  

  int loadConfig    (void);
  // PURPOSE: load a site defined configuration file with routine name
  //          _cdev_site_config (cdevSystem& system)
  // REQUIRE: none
  // PROMISE: return 0: configuration loaded. return -1: failed

protected:
  
  // flag that denotes whether the system has tried load config or not
  static int tloadconfig_;

private:
  // deny assignment and copy operations
  cdevConfigFinder (const cdevConfigFinder& finder);
  cdevConfigFinder& operator = (const cdevConfigFinder& finder);

  // data area
  shObjLoader* loader_;
  cdevSystem&  system_;
};

#else

#include <stdio.h>
#include <string.h>
#include <cdevSystem.h>

class cdevConfigFinder
{
public:
  // constructor
  cdevConfigFinder  (cdevSystem& system = cdevSystem::defaultSystem ());

  int loadConfig    (void) {return 0;}
private:
  // deny assignment and copy operations
  cdevConfigFinder (const cdevConfigFinder& finder);
  cdevConfigFinder& operator = (const cdevConfigFinder& finder);
};
#endif

#endif

  
