//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Skeleton Service
//
// Author:  Jie Chen
//
// Revision History:
//   skService.h,v
// Revision 1.2  1995/07/22  22:59:01  watson
// var1,var2 version
//
// Revision 1.1  1995/07/22  20:20:10  watson
// add skeleton service
//
//
#ifndef _CDEV_SK_SERVICE_H
#define _CDEV_SK_SERVICE_H

#include <cdevSpec.h>
#include <cdevService.h>

extern "C" CDEVSVCAPI cdevService *newSkService (char *name, cdevSystem* system);

class CDEVSVC_CLASS_SPEC skService: public cdevService
{
public:
  // constructor
  skService (char* name, cdevSystem& system = cdevSystem::defaultSystem ());
  
  // get fd
  int getFd (int* &fd, int& numFd);

  // network operations
  int flush (void);
  int poll  (void);
  int pend  (int fd = -1);
  int pend  (double seconds, int fd = -1);

  // return right request object
  int getRequestObject (char *device, char *msg, 
			cdevRequestObject* &reqobj);

  // get name server, no use now
  int getNameServer (cdevDevice* &ns);

  // tag values
  static int SK_TAG_VALUE;
  static int SK_TAG_XYZ;

  // class name
  const char *className (void) const {return "skService";}

protected:
  // deny access to destructor
  ~skService (void);
  // map char tags to int tags
  static void mapCtagToItag (void);

private:
  // friend class
  friend class skRequestObject;
  int var1;
  int var2;
};

#endif




