//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdev skeleton service
//
// Author:  Jie Chen, Chip Watson
//
// Revision History:
//   skService.cc,v
// Revision 1.2  1995/07/22  22:59:00  watson
// var1,var2 version
//
// Revision 1.1  1995/07/22  20:20:09  watson
// add skeleton service
//
//
#include <cdevData.h>
#include <cdevCallback.h>
#include "skService.h"
#include "skRequestObject.h"

int skService::SK_TAG_XYZ = 0;   	// tag for service data
int skService::SK_TAG_VALUE = 0;	// tag for "value" data

skService::skService (char *name, cdevSystem& system)
:cdevService (name, system), var1 (100), var2 (1000)
{
#ifdef _TRACE_OBJECTS
  printf ("         Create skService Class Object\n");
#endif
  // add tags to this service
  if (skService::SK_TAG_VALUE == 0) {
    cdevData::addTag ("XYZ");
    skService::mapCtagToItag ();
  }
}

skService::~skService (void)
{
#ifdef _TRACE_OBJECTS
  printf ("         Delete skService Class Object\n");
#endif
}

int
skService::getFd (int* &fd, int& numfd)
{
  fd = 0;
  numfd = 0;
  return CDEV_SUCCESS;
}

int
skService::flush (void)
{
  printf ("skService flush\n");
  return CDEV_SUCCESS;
}

int
skService::poll (void)
{
  // no outstanding work, so return
  return CDEV_SUCCESS;
}

int
skService::pend (int)
{
  // no outstanding work, so return
  return CDEV_SUCCESS;
}

int
skService::pend (double, int)
{
  // no outstanding work, so return
  return CDEV_SUCCESS;
}

int
skService::getRequestObject (char* device,
			     char* msg,
			     cdevRequestObject* &reqobj)
{
  reqobj = new skRequestObject (device, msg, system_);
  if (reqobj)
    return CDEV_SUCCESS;
  else
    return CDEV_ERROR;
}

int
skService::getNameServer (cdevDevice* &ns)
{
  // this service does not implement a name server device
  ns = 0;
  return CDEV_SUCCESS;
}


void
skService::mapCtagToItag (void)
{
  // cache the integer equivalent of "value" tag
  cdevData::tagC2I ("value", &skService::SK_TAG_VALUE);
  cdevData::tagC2I ("XYZ", &skService::SK_TAG_XYZ);
}
  

cdevService *
newSkService (char *name, cdevSystem* sys)
{
  return new skService (name, *sys);
}
