// Simple test program to config cebaf error reporting system
// of cdev system
#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevData.h>

extern "C" int _cdev_site_config (cdevSystem* sys);

static cdevRequestObject* cmlogobj = 0;

static void
cebafErrorReport (int severity,
		  char* text,
		  cdevRequestObject* obj)
{
  cdevData data;

  data.insert ("facility", "cdevSystem");
  data.insert ("severity", severity);
  data.insert ("text", text);

  cmlogobj->send (data, 0);
}

int
_cdev_site_config (cdevSystem* sys)
{
  cmlogobj = cdevRequestObject::attachPtr ("cmlog", "set msg");

  if (!cmlogobj)
    return -1;

  sys->attachErrorHandler (cebafErrorReport);

  sys->reportError (CDEV_SEVERITY_INFO, 
		    "CEBAF local cmlog error handler is installed",
		    0);
  return 0;
}
