//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdev deferred execution object (for service developer only)
//
//      deferred execution object is registered into one and only one
//      opened group which is the outmost deferred one
//
// Author:  Jie Chen
//
// Revision History:
//   cdevExecObj.h,v
// Revision 1.2  1997/03/03  17:36:03  chen
// add buffering to channel access connection
//
// Revision 1.1  1995/12/08  15:34:50  chen
// execution object
//
//
#ifndef _CDEV_EXEC_OBJ_H
#define _CDEV_EXEC_OBJ_H

#include <stdio.h>
#include <assert.h>
#include <cdevSystem.h>
#include <cdevData.h>
#include <cdevCallback.h>

class cdevGroup;
class cdevRequestObject;

class CDEV_CLASS_SPEC cdevExecObj
{
public:
  // constructor and destructor
  cdevExecObj  (void);
  cdevExecObj  (cdevSystem*         sys,
		cdevRequestObject*  reqobj,
		cdevData*           out,
		cdevData*           result,
		cdevCallback*       callback,
		cdevGroup*          execg = 0,
		void*               arg = 0);
  // Important note:
  // No objects pointed by the pointers will be deleted from this object
  ~cdevExecObj (void);

  int status (void) const;
  // PURPOSE: return status of transaction object
  // REQUIRE: nothing
  // PROMISE: -1: not registered into any group, 1: registered into groups

  int removeFromGrps (void);
  // PURPOSE: remove this transaction object from all groups
  // REQUIRE: nothing
  // PROMISE: status = -1

  // data area for requestObject to access
  cdevSystem        *system_;
  cdevRequestObject *reqObj_;
  cdevData          *outData_;
  cdevData          *resultData_;
  cdevCallback      *userCallback_;
  int               status_;
  cdevGroup         *deferredGroup_;
  // pointer entries to the entry inside deferred group
  cdevExecObj       **entryPtr_;
  // any user provided argument
  void              *arg_;

  virtual const char *className (void) const {return "cdevExecObj";}

private:
  // deny copy and assignment operation
  // It makes no sense for two identical transaction objects
  cdevExecObj  (const cdevExecObj& rsc);
  cdevExecObj& operator = (const cdevExecObj& rsc);

  // friend class 
  friend class cdevGroup;
};
#endif











