//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevRequestObject for cdevDirectory Class
//
// Author:  Jie Chen
//
// Revision History:
//   cdevDirRequestObj.cc,v
// Revision 1.1  1998/02/13  14:01:45  chen
// enable request object for cdevDirectory
//
//
#include "cdevDirRequestObj.h"

cdevDirRequestObj::cdevDirRequestObj (cdevDevice& device,
				      char* msg,
				      cdevSystem& system)
:cdevRequestObject (device, msg, system)
{
#ifdef _TRACE_OBJECTS
  printf ("              Create cdevDirRequestObj Class Object\n");
#endif
}

cdevDirRequestObj::~cdevDirRequestObj (void)
{
#ifdef _TRACE_OBJECTS
  printf ("              Delete cdevDirRequestObj Class Object\n");
#endif
}

int
cdevDirRequestObj::send (cdevData& out, cdevData& result)
{
  return send (&out, &result);
}

int
cdevDirRequestObj::send (cdevData& out, cdevData* result)
{
  return send (&out, result);
}

int
cdevDirRequestObj::send (cdevData* out, cdevData& result)
{
  return send (out, &result);
}

int
cdevDirRequestObj::send (cdevData* out, cdevData* result)
{
  return device_->send (message_, out, result);
}


int
cdevDirRequestObj::sendNoBlock (cdevData& out, cdevData& result)
{
  return sendNoBlock (&out, &result);
}

int
cdevDirRequestObj::sendNoBlock (cdevData& out, cdevData* result)
{
  return sendNoBlock (&out, result);
}

int
cdevDirRequestObj::sendNoBlock (cdevData* out, cdevData& result)
{
  return sendNoBlock (out, &result);
}

int
cdevDirRequestObj::sendNoBlock (cdevData* out, cdevData* result)
{
  return device_->sendNoBlock (message_, out, result);
}

int
cdevDirRequestObj::sendCallback (cdevData& out, cdevCallback& cbk)
{
  return sendCallback (&out, cbk);
}

int
cdevDirRequestObj::sendCallback (cdevData* out, cdevCallback& cbk)
{
  return device_->sendCallback(message_, out, cbk);
}


