//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevIOcontext class implementation
//
// Author:  Jie Chen & Chip Watson
//
// Revision History:
//   cdevIOcontext.cc,v
// Revision 1.1.1.1  1995/06/16  17:14:06  epics
// initial import of cdev
//
//
#include <stdio.h>
#include <cdevErrCode.h>
#include"cdevIOcontext.h"

cdevIOcontext::cdevIOcontext (void)
:data_(), userData_(0)
{
#ifdef _TRACE_OBJECTS
  printf("Create cdevIOcontext class\n");
#endif
  // empty
}

cdevIOcontext::~cdevIOcontext (void)
{
#ifdef _TRACE_OBJECTS
  printf("Destroy cdevIOcontext class\n");
#endif
  // do not delete userData_, user has control over it
}

cdevData&
cdevIOcontext::getContext (void)
{
  return data_;
}

int
cdevIOcontext::setContext (cdevData& newData)
{
  data_ = newData;
  return CDEV_SUCCESS;
}

void
cdevIOcontext::setPrivate (void *newUserData)
{
  userData_ = newUserData;
}

void *
cdevIOcontext::getPrivate (void)
{
  return (void *)userData_;
}
