//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//       C++ Class for timeval structure 
//
// Author:  Jie Chen
//
// Revision History:
//   cdevTimeValue.h,v
// Revision 1.2  1998/02/10  18:04:57  chen
// add cdevSystem timer handler
//
// Revision 1.1.1.1  1995/06/16  17:14:02  epics
// initial import of cdev
//
//
#ifndef _CDEV_TIME_VALUE_H
#define _CDEV_TIME_VALUE_H

#include <cdevSpec.h>
#include <math.h>

#ifdef _WIN32
  #include <sys/types.h>
  #include <sys/timeb.h>
  #include <winsock2.h>
#else
  #include <sys/time.h>
#endif

class CDEV_CLASS_SPEC cdevTimeValue
{
 public:
  cdevTimeValue (long sec = 0, long usec = 0);
  cdevTimeValue (double sec);
#ifdef _WIN32
  cdevTimeValue (const struct _timeb &t);
#endif
  cdevTimeValue (const timeval &t);
  cdevTimeValue (const cdevTimeValue &tv);
  cdevTimeValue& operator = (const cdevTimeValue& tv);

#ifdef _WIN32
  void set      (const struct _timeb &t);
#endif

  void set      (const timeval &t);
  long sec      (void) const;
  void sec      (long sec);
  long usec     (void) const;
  void usec     (long usec);
  operator double  () const;
#ifdef _WIN32
  operator struct _timeb () const;
#endif
  operator timeval () const;

  void operator += (const cdevTimeValue& val);
  void operator -= (const cdevTimeValue& val);

  friend cdevTimeValue operator + (cdevTimeValue tv1, cdevTimeValue tv2);
  friend cdevTimeValue operator - (cdevTimeValue tv1, cdevTimeValue tv2);
  friend int	       operator < (cdevTimeValue tv1, cdevTimeValue tv2);
  friend int	       operator > (cdevTimeValue tv1, cdevTimeValue tv2);  
  friend int	       operator <= (cdevTimeValue tv1, cdevTimeValue tv2);
  friend int	       operator >= (cdevTimeValue tv1, cdevTimeValue tv2);  
  friend int	       operator == (cdevTimeValue tv1, cdevTimeValue tv2);  
  friend int	       operator != (cdevTimeValue tv1, cdevTimeValue tv2);  

  static const cdevTimeValue zero;
  static cdevTimeValue currentTime (void);

 private:
  void normalize (void);

  long tv_sec_;
  long tv_usec_;
};
#endif
