/* -----------------------------------------------------------------------------
 *  Copyright (c) 1994,1995 Southeastern Universities Research Association,
 *                          Continuous Electron Beam Accelerator Facility
 * 
 *  This software was developed under a United States Government license
 *  described in the NOTICE file included as part of this distribution.
 * 
 * -----------------------------------------------------------------------------
 * 
 *  Description:
 *       cdevErrorCollection class implementation
 * 
 *  Author:  Walt Akers, Chip Watson & Jie Chen
 * 
 *  Revision History:
 *    cdevErrorCollection.cc,v
// Revision 1.1  1996/11/12  20:32:27  akers
// New collection device source code
//
 * -----------------------------------------------------------------------------
 */ 

#include <stdio.h>
#include <string.h>
#include <assert.h>

#include <cdevErrCode.h>
#include "cdevErrorCollection.h"

cdevErrorCollection::cdevErrorCollection (char *devName)
:cdevCollection(devName)
{
#ifdef _TRACE_OBJECTS
  printf("    Create cdevErrorCollection class object\n");
#endif
  deviceName_ = new char[::strlen(devName) + 1];
  ::strcpy (deviceName_, devName);
}

cdevErrorCollection::~cdevErrorCollection (void)
{
#ifdef _TRACE_OBJECTS
  printf("    Destroy cdevErrorCollection class object\n");
#endif
}

cdevRequestObject*
cdevErrorCollection::getRequestObject (char *msg)
{
  cdevRequestObject *obj = NULL;
  getRequestObject (msg, obj);
  return obj;
}

int
cdevErrorCollection::getRequestObject (char *, cdevRequestObject* &reqobj)
{
  reqobj = NULL;
  return CDEV_INVALIDOBJ;
}

int
cdevErrorCollection::add(char *, ...)
{
  return CDEV_INVALIDOBJ;
}

int
cdevErrorCollection::add(char **, int)
{
  return CDEV_INVALIDOBJ;
}

int
cdevErrorCollection::addRegexp(char *)
{
  return CDEV_INVALIDOBJ;
}

int
cdevErrorCollection::remove(char *, ...)
{
  return CDEV_INVALIDOBJ;
}

int
cdevErrorCollection::remove(char **, int )
{
  return CDEV_INVALIDOBJ;
}

int
cdevErrorCollection::removeRegexp(char *)
{
  return CDEV_INVALIDOBJ;
}

