/*---------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *----------------------------------------------------------------------------
 *
 * description: cdevDataEntry.h
 *	Self describing data class.  Designed to hold individual tagged data
 *	items within a cdevData class.
 *
 * Author: Walt Akers & Danjin Wu
 *
 * Revision History:
 *   cdevTypes.h,v
 * Revision 1.5  1998/03/10  19:57:39  chen
 * change to C style comment
 *
 * Revision 1.4  1998/03/10  18:54:27  chen
 * cdevTypes.h
 *
 * Revision 1.3  1995/09/06  18:35:11  danjin
 * added time stamp structure type
 *
 * Revision 1.2  1995/07/14  13:25:32  akers
 * Header files added to support the changes specified at June 95 Review
 *
 *
 *                                       
 */
#ifndef _CDEV_TYPES_H
#define _CDEV_TYPES_H

#include <stddef.h> 

typedef unsigned char BYTE;

enum cdevDataTypes 
	{
	CDEV_BYTE, 
	CDEV_INT16, 
	CDEV_UINT16,
	CDEV_INT32,
	CDEV_UINT32,
	CDEV_FLOAT, 
	CDEV_DOUBLE, 
	CDEV_STRING, 
	CDEV_TIMESTAMP,
	CDEV_INVALID
	};
 
typedef struct
	{
	size_t offset;
	size_t length;
	} cdevBounds;

/* cdev time struct */
typedef struct {
    unsigned long   secPastEpoch;    /* seconds since Jan. 1, 1970 */
    unsigned long   nsec;            /* nanoseconds within second  */
} cdev_TS_STAMP;

#endif
