//------------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//------------------------------------------------------------------------------
//
// description: cdevDataEntry.cc
//	This file contains the non-inlined functions associated with the
// 	cdevDataEntry family of classes.
//
// Author: Walt Akers
//
// Revision History:
//   cdevDataEntry.cc,v
// Revision 1.4  1996/11/21  17:03:01  akers
// Ongoing Developement of CDEV 1.5
//
// Revision 1.3  1996/08/23  21:24:23  akers
// Corrected Problem with operator ==
//
// Revision 1.2  1995/07/14  13:01:14  akers
// Updated version of cdevData source code
//
//
//                                       
//------------------------------------------------------------------------------
#include "cdevDataEntry.h"


// *****************************************************************************
// * cdevDataEntryeStorage::operator ==:
// *	This operator allows you to directly and rapidly compare two 
// *	cdevDataEntryStorage objects...
// *****************************************************************************
int cdevDataEntryStorage::operator == (cdevDataEntryStorage & entry)
	{
	int result = 0;
	int i      = 0;
	
	// *********************************************************************
	// * First compare all of the pertinent scalar values...
	// *********************************************************************
	if(tag_      == entry.tag_      &&
	   dataType_ == entry.dataType_ &&
	   dim_      == entry.dim_      &&
	   elems_    == entry.elems_)
		{
		// *************************************************************
		// * Next compare the contents of the data items...
		// *************************************************************
		if(dim_) 
			{
			result = 0;
			if(dataType_==CDEV_BYTE)
				for(i=0; i<elems_ && !result; i++)
					result=!(data_.cptr[i]==entry.data_.cptr[i]);
			else if(dataType_==CDEV_INT16)
				for(i=0; i<elems_ && !result; i++)
					result=!(data_.sptr[i]==entry.data_.sptr[i]);
			else if(dataType_==CDEV_UINT16)
				for(i=0; i<elems_ && !result; i++)
					result=!(data_.usptr[i]==entry.data_.usptr[i]);
			else if(dataType_==CDEV_INT32)
				for(i=0; i<elems_ && !result; i++)
					result=!(data_.lptr[i]==entry.data_.lptr[i]);
			else if(dataType_==CDEV_UINT32)
				for(i=0; i<elems_ && !result; i++)
					result=!(data_.ulptr[i]==entry.data_.ulptr[i]);
			else if(dataType_==CDEV_FLOAT)
				for(i=0; i<elems_ && !result; i++)
					result=!(data_.fptr[i]==entry.data_.fptr[i]);
			else if(dataType_==CDEV_DOUBLE)
				for(i=0; i<elems_ && !result; i++)
					result=!(data_.dptr[i]==entry.data_.dptr[i]);
			else if(dataType_==CDEV_STRING)
				for(i=0; i<elems_ && !result; i++)
					result=strcmp(data_.strarr[i], entry.data_.strarr[i]);
			else if(dataType_==CDEV_TIMESTAMP)
				for(i=0; i<elems_ && !result; i++)
					result=!((data_.tsptr[i].nsec==entry.data_.tsptr[i].nsec) && 
		                                 (data_.tsptr[i].secPastEpoch==entry.data_.tsptr[i].secPastEpoch));
			else result=memcmp(buffer_, entry.buffer_, (dim_*sizeof(cdevBounds))+(elems_*bytes_));
			}
		else if(dataType_==CDEV_BYTE)      result=!(data_.cval==entry.data_.cval);
		else if(dataType_==CDEV_INT16)     result=!(data_.sval==entry.data_.sval);
		else if(dataType_==CDEV_UINT16)    result=!(data_.usval==entry.data_.usval);
		else if(dataType_==CDEV_INT32)     result=!(data_.lval==entry.data_.lval);
		else if(dataType_==CDEV_UINT32)    result=!(data_.ulval==entry.data_.ulval);
		else if(dataType_==CDEV_FLOAT)     result=!(data_.fval==entry.data_.fval);
		else if(dataType_==CDEV_DOUBLE)    result=!(data_.dval==entry.data_.dval);
		else if(dataType_==CDEV_STRING)    result=strcmp(data_.str, entry.data_.str);
		else if(dataType_==CDEV_TIMESTAMP) result=!((data_.ts.nsec==entry.data_.ts.nsec) && 
		                                            (data_.ts.secPastEpoch==entry.data_.ts.secPastEpoch));
		else result = memcmp(&data_, &entry.data_, sizeof(data_));
		} 
	else result = -1;
	return !result;
	}

// *****************************************************************************
// * Global initialization of the static freeList_ member of the 
// * cdevDataEntry class.
// *****************************************************************************
cdevDataEntry * cdevDataEntry::freeList_ = NULL;

// *****************************************************************************
// * new:
// * Allocation function for the object.  It will get the next preallocated 
// * cdevDataEntry object from the freeList_, or, if none are available, 
// * refill the freeList_ and then return a new cdevDataEntry object.
// *****************************************************************************
void * cdevDataEntry::operator new ( size_t )
	{
	cdevDataEntry * result = NULL;
	
	if(freeList_==NULL)
		{
		freeList_ = ::new cdevDataEntry[ALLOCATION_COUNT];
		for(int i=0; i<ALLOCATION_COUNT; i++) {
			freeList_[i].next_ = (i<(ALLOCATION_COUNT-1))?&freeList_[i+1]:(cdevDataEntry *)NULL;
			}
		}
	
	if(freeList_!=NULL) {
		result = freeList_;
		freeList_ = result->next_;
		}

	return result;
	}
