//---------------------------------------------------------------------------
// Copyright (c) 1991,1992 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//----------------------------------------------------------------------------
//
// description: cdevData.h
//	Self descibing data structure to manage the storage and transport
//	of data between local cdev functions, as well as remote client and
//	server applications.
//
// Author: Walt Akers and Danjin Wu
//
// Revision History:
//   cdevData.i,v
// Revision 1.6  1996/11/21  17:02:59  akers
// Ongoing Developement of CDEV 1.5
//
// Revision 1.5  1996/07/12  18:09:01  chen
// change copy and assignment to const cdevData&
//
// Revision 1.4  1996/04/12  13:40:07  akers
// Added char * cast operator
//
// Revision 1.3  1996/02/27  20:50:13  danjin
// add assignment operator from various typed data to cdevData object
//
// Revision 1.2  1995/10/16  18:14:20  chen
// Fix a bug for SunOs and g++
//
// Revision 1.1  1995/10/06  19:39:03  chen
// all cdevData inline functions
//
//
INLINE
cdevDataEntry* cdevData::lookupTag(char * ctag, int create) 
{ 
  int tag; 
  return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?
  (cdevDataEntry *)0:lookupTag(tag, create); 
}

INLINE
cdevData & 
cdevData::operator = (const cdevData & data) 
{ 
  return copy(data);
}

INLINE
void cdevData::remove( char * ctag )
{
  int tag; if(!cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)) remove(tag);
}

INLINE
cdevDataTypes cdevData::getType(char *ctag)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?
  CDEV_INVALID:getType(tag);
}

INLINE
int cdevData::getDim(char *ctag, size_t *dim)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?
  CDEV_NOTFOUND:getDim(tag, dim); 
}

INLINE
int cdevData::getElems(char *ctag, size_t *elems)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?
  CDEV_NOTFOUND:getElems(tag, elems); 
}

INLINE
int cdevData::getBounds(char * ctag, size_t * bounds, size_t len)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?
  CDEV_NOTFOUND:getBounds(tag, bounds, len); 
}

INLINE
int cdevData::getBounds(char * ctag, cdevBounds * bounds, size_t numBounds)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?
  CDEV_NOTFOUND:getBounds(tag, bounds, numBounds); 
}

INLINE
int cdevData::setBounds(char * ctag, size_t * bounds, size_t len)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?
  CDEV_NOTFOUND:setBounds(tag, bounds, len); 
}

INLINE
int cdevData::setBounds(char * ctag, cdevBounds * bounds, size_t numBounds)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?
  CDEV_NOTFOUND:setBounds(tag, bounds, numBounds); 
}

INLINE
int cdevData::insert ( char * ctag, BYTE data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data); 
}

INLINE
int cdevData::insert ( char * ctag, short data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data); 
}

INLINE
int cdevData::insert ( char * ctag, unsigned short data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data); 
}

INLINE
int cdevData::insert ( char * ctag, long data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data);
}

INLINE
int cdevData::insert ( char * ctag, unsigned long data)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data);
}

INLINE
int cdevData::insert ( char * ctag, float data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data); 
}

INLINE
int cdevData::insert ( char * ctag, double data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data); 
}

INLINE
int cdevData::insert ( char * ctag, cdev_TS_STAMP data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data); 
}

INLINE
int cdevData::insert (char * ctag, BYTE * data, size_t len, size_t ndim)
{ 
int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim); 
}

INLINE
int cdevData::insert (char * ctag, short * data, size_t len, size_t ndim)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim); 
}

INLINE
int cdevData::insert (char * ctag, unsigned short * data, size_t len, size_t ndim)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim);
}

INLINE
int cdevData::insert (char * ctag, long * data, size_t len, size_t ndim)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim);
}

INLINE
int cdevData::insert (char * ctag, unsigned long * data, size_t len, size_t ndim)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim); 
}

INLINE
int cdevData::insert (char * ctag, float * data, size_t len, size_t ndim)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim); 
}

INLINE
int cdevData::insert (char * ctag, double * data, size_t len, size_t ndim)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim); 
}

INLINE
int cdevData::insert ( char * ctag, char * data)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data); 
}

INLINE
int cdevData::insert ( char * ctag, char ** data, size_t len, size_t ndim)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim); 
}

INLINE
int cdevData::insert (char * ctag, cdev_TS_STAMP * data, size_t len, size_t ndim)
{ 
int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:insert(tag, data, len, ndim); 
}

INLINE
int cdevData::get(char * ctag, BYTE * data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::get(char * ctag, short * data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::get(char * ctag, unsigned short * data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::get(char * ctag, long * data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::get(char * ctag, unsigned long * data) 
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::get(char * ctag, float * data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::get(char * ctag, double * data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::get(char * ctag, char * data, size_t len) 
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data, len); 
}

INLINE
int cdevData::get(char * ctag, char ** data)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::get(char * ctag, cdev_TS_STAMP * data)
{
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:get(tag, data); 
}

INLINE
int cdevData::find(char * ctag, void* &data)
{ 
  int tag; return cdevGlobalTagTable::tagTable()->tagC2I(ctag, &tag)?CDEV_NOTFOUND:find(tag, data); 
}

#ifdef DEFAULT_16_BIT_INTEGER
INLINE
int cdevData::insert ( int tag, int data )             
{ 
  return insert(tag, (short)data); 
}

INLINE
int cdevData::insert ( int tag, unsigned int data ) 
{ 
  return insert(tag, (unsigned short)data); 
}

INLINE
int cdevData::insert ( char * ctag, int data) 
{ 
  return insert(ctag, (short)data); 
}

INLINE
int cdevData::insert ( char * ctag, unsigned int data) 
{ 
  return insert(ctag, (unsigned short)data);
}

INLINE
int cdevData::insert (int tag, int * data, size_t len, size_t ndim)
{ 
  return insert(tag, (short *)data, len, ndim); 
}

INLINE
int cdevData::insert (int tag, unsigned int * data, size_t len, size_t ndim)
{ 
  return insert(tag, (unsigned short *)data, len, ndim); 
}

INLINE
int cdevData::insert (char * ctag, int * data, size_t len, size_t ndim)
{ 
  return insert(ctag, (short *)data, len, ndim); 
}

INLINE
int cdevData::insert (char * ctag, unsigned int * data, size_t len, size_t ndim)
{ 
  return insert(ctag, (unsigned short *)data, len, ndim); 
}
#else
INLINE
int cdevData::insert ( int tag, int data )             
{ 
  return insert(tag, (long)data); 
}

INLINE
int cdevData::insert ( int tag, unsigned int data )
{ 
  return insert(tag, (unsigned long)data); 
}

INLINE
int cdevData::insert ( char * ctag, int data)          
{ 
  return insert(ctag, (long)data); 
}

INLINE
int cdevData::insert ( char * ctag, unsigned int data) 
{ 
  return insert(ctag, (unsigned long)data);
}

INLINE
int cdevData::insert (int tag, int * data, size_t len, size_t ndim)
{ 
  return insert(tag, (long *)data, len, ndim); 
}

INLINE
int cdevData::insert (int tag, unsigned int * data, size_t len, size_t ndim)
{ 
  return insert(tag, (unsigned long *)data, len, ndim); 
}

INLINE
int cdevData::insert (char * ctag, int * data, size_t len, size_t ndim)
{ 
  return insert(ctag, (long *)data, len, ndim);
}

INLINE
int cdevData::insert (char * ctag, unsigned int * data, size_t len, size_t ndim)
{
  return insert(ctag, (unsigned long *)data, len, ndim); 
}
#endif

#ifdef DEFAULT_16_BIT_INTEGER
INLINE
int cdevData::get(int tag, int * data)
{ 
  return get(tag, (short *)data); 
}

INLINE
int cdevData::get(int tag, unsigned int * data)
{
  return get(tag, (unsigned short *) data);
}

INLINE
int cdevData::get(char *ctag, int * data)
{ 
  return get(ctag, (short *)data); 
}

INLINE
int cdevData::get(char *ctag, unsigned int * data)
{ 
  return get(ctag, (unsigned short *) data); 
}
#else	
INLINE
int cdevData::get(int tag, int * data) 
{
  return get(tag, (long *)data); 
}

INLINE
int cdevData::get(int tag, unsigned int * data)
{
  return get(tag, (unsigned long *) data); 
}

INLINE
int cdevData::get(char *ctag, int * data)
{ 
  return get(ctag, (long *)data); 
}

INLINE
int cdevData::get(char *ctag, unsigned int * data) 
{ 
  return get(ctag, (unsigned long *) data); 
}
#endif	
 
INLINE
cdevData::operator char( void )
{ 
  BYTE x;   get((char *)("value"), &x); return x; 
}

INLINE
cdevData::operator short( void ) 
{ 
  short x;  get((char *)("value"), &x); return x; 
}	

INLINE
cdevData::operator unsigned short( void ) 
{ 
  unsigned short x;  get((char *)("value"), &x); return x; 
}	

INLINE
cdevData::operator int( void )
{
  int x;   get((char *)("value"), &x); return x; 
}

INLINE
cdevData::operator unsigned int( void ) 
{ 
  unsigned int x;   get((char *)("value"), &x); return x;
}

INLINE
cdevData::operator long( void ) 
{
  long x;   get((char *)("value"), &x); return x; 
}

INLINE
cdevData::operator unsigned long( void ) 
{
  unsigned long x;   get((char *)("value"), &x); return x; 
}

INLINE
cdevData::operator float( void )
{ 
  float x;  get((char *)("value"), &x); return x; 
}

INLINE
cdevData::operator double( void ) 
{
  double x; get((char *)("value"), &x); return x; 
}


INLINE 
cdevData::operator char * ( void )
{
char *        result = NULL;
static char   temp[64];
size_t        dim      = 0;
int           valueTag = 1;
cdevDataTypes dataType = CDEV_INVALID;

tagC2I((char *)("value"), &valueTag);
getDim(valueTag, &dim);
if(dim==0) dataType = getType(valueTag);

switch(dataType)
	{	
	case CDEV_INVALID:
		result=NULL;
		break;
		
	case CDEV_STRING:
		find((char *)("value"), (void * &)result);
		break;

	default:
		get((char *)("value"), temp, 64);
		result = temp;
		break;
		 
	}
return result;
}


INLINE
cdevData& cdevData::operator= (unsigned char x)
{
  insert((char *)("value"), x);
  return *this;
}

INLINE  cdevData& cdevData::operator= (short x)
{
  insert((char *)("value"), x);  
  return *this;
}

INLINE  cdevData& cdevData::operator= (unsigned short x)
{
  insert((char *)("value"), x);  
  return *this;
}

INLINE  cdevData& cdevData::operator= (int x)
{
  insert((char *)("value"), x);  
  return *this;
}

INLINE  cdevData& cdevData::operator= (unsigned int x)
{
  insert((char *)("value"), x);  
  return *this;
}
INLINE  cdevData& cdevData::operator= (long x)
{
  insert((char *)("value"), x);  
  return *this;
}

INLINE  cdevData& cdevData::operator= (unsigned long x)
{
  insert((char *)("value"), x);  
  return *this;
}

INLINE  cdevData& cdevData::operator= (float x)
{
  insert((char *)("value"), x);  
  return *this;
}

INLINE  cdevData& cdevData::operator= (double x)
{
  insert((char *)("value"), x);  
  return *this;
}



