DIRS    = callback\
	  cdevIO\
	  common\
	  directory\
	  collection\
	  group\
	  system\
	  device\
	  regexp\
	  xdr\
	  c_interface

BINDIRS = utility
LIBDIRS = lib ca

all : 
	@echo ---------------------------------------------------------------
	@echo Building CDEV Libraries for Target : WINNT-4.0
	@echo ---------------------------------------------------------------
	-@if not exist ..\include mkdir ..\include
	@for %x in ($(DIRS) $(LIBDIRS) $(BINDIRS)) DO @$(MAKE) /NOLOGO /f NMakefile.mak SUBTARGETDIR=%x SUBTARGET=all subtarget
	@echo ---------------------------------------------------------------
	@echo CDEV Libraries Have Been Built for Target : WINNT-4.0
	@echo ---------------------------------------------------------------

clean : 
	@for %x in ($(DIRS) $(LIBDIRS) $(BINDIRS)) DO @$(MAKE) /NOLOGO /f NMakefile.mak SUBTARGETDIR=%x SUBTARGET=clean subtarget
	-@for %x in (..\include\*.h ..\include\*.i) DO @erase %x
	
purge : 
	@for %x in ($(DIRS) $(LIBDIRS) $(BINDIRS)) DO @$(MAKE) /NOLOGO /f NMakefile.mak SUBTARGETDIR=%x SUBTARGET=purge subtarget
	-@for %x in (..\include\*.h ..\include\*.i) DO @erase %x
	-@rmdir /s /q ..\lib
	-@rmdir /s /q ..\bin

!IF "$(SUBTARGETDIR)" == ""
subtarget : 
	-@echo SUBTARGETDIR variable must be defined to build subtargets
!ELSE
!IF "$(SUBTARGET)" == ""
SUBTARGET = all
!ENDIF
subtarget :
	-@echo =^> Building target $(SUBTARGET) in directory $(SUBTARGETDIR)
	@cd $(SUBTARGETDIR)
	@$(MAKE) /NOLOGO /f NMakefile.mak $(SUBTARGET)
	@echo ^<= Done...	 
!ENDIF	
