/* -----------------------------------------------------------------------------
 * Copyright (c) 1994,1995 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * -----------------------------------------------------------------------------
 *
 * grpCallbackCollector : This class is used to collect the callbacks from a
 *                        a group of collections and then compile the results
 *                        into a single cdevData object.
 *
 *                        The cdevCollectionRequest object will obtain the 
 *                        cdevData object from this object and will return it
 *                        to the caller.
 *
 * Author:  Walt Akers
 *
 * Revision History:
 *   grpCallbackCollector.h,v
 * Revision 1.1  1996/11/12  20:32:41  akers
 * New collection device source code
 *
 * -----------------------------------------------------------------------------
 */
#ifndef _GRP_CALLBACK_COLLECTOR_H_
#define _GRP_CALLBACK_COLLECTOR_H_

#include <cdevData.h>
#include <cdevTranObj.h>
#include <cdevCollectionRequest.h>

class grpCallbackCollector
{
public:
	typedef struct
		{
		int                    index;
		int                    elements;
		int                    processed;
		grpCallbackCollector * parent;
		} Request;

	int           counter;
	cdevData      result;
	cdevData    & format;
	cdevTranObj * xobj;
	Request     * collections;
	int           nCollections;
	int         * requestOrder;
	int           nRequests;

	grpCallbackCollector   (int NCollections, int * RequestOrder, int NRequests, 
	                        cdevData &Format, cdevTranObj &XObj);
	~grpCallbackCollector  ( void );
	int  finished          ( void ); 
	void processCollection ( int idx, int status, cdevData *data = NULL );
	void mergeData         ( cdevData &to, cdevData &from, int idx );
	void copyItemsToArray  ( cdevData &to, cdevData &from, int tag, int idx );
	void installEmptyArray ( cdevData &data, int tag, cdevDataTypes type, int size );
};

#endif /* _GRP_CALLBACK_COLLECTOR_H_ */
