//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevTimerQueue Class
//
// Author:  Jie Chen
//
// Revision History:
//   cdevTimerQueue.h,v
// Revision 1.1  1998/02/10  18:04:58  chen
// add cdevSystem timer handler
//
//
//
#ifndef _CDEV_TIMER_QUEUE_H
#define _CDEV_TIMER_QUEUE_H

#include <stdio.h>
#include <cdevTimerHandler.h>
#include <cdevSlist.h>

class cdevTimerQueue;

class cdevTimerQNode
{
private:

  friend class cdevTimerQueue;

  cdevTimerQNode (cdevTimerHandler* h,
		  const void* arg,
		  const cdevTimeValue& t,
		  const cdevTimeValue& i,
		  int   id);

  // data area
  cdevTimerHandler* handler_;

  // user argument
  const void*       arg_;

  // first time interval to expire
  cdevTimeValue     timer_;

  // timer interval: if this is not zero this holds the time until the next
  // timeout
  cdevTimeValue     interval_;

  // int timer id
  int               tid_;
};


class CDEV_CLASS_SPEC cdevTimerQueue
{
public:
  // constructor
  cdevTimerQueue (void);
  // destructor
  virtual ~cdevTimerQueue (void);

  int isEmpty    (void) const;
  // PURPOSE: check whether this queue is empty or not
  // REQUIRE: nothing
  // PROMISE: return 1, empty, 0, not empty

  const cdevTimeValue& earliestTime (void) const;
  // PURPOSE: return earliestTime in the timer queue
  // REQUIRE: nothing
  // PROMISE: time value denoted the earliest time in the queue

  int   scheduleTimer (cdevTimerHandler* handler,
		       const void* arg,
		       const cdevTimeValue& delay,
		       const cdevTimeValue& interval = cdevTimeValue::zero);
  // PURPOSE: Schedule an <cdevTimerHandler> that will expire after <delay>
  // amount of time.  If it expires then <arg> is passed in as the value to
  // the <cdevTimerHandler>'s <timerCallback> callback method.  If
  // <interval> is != to <cdevTimeValue::zero> then it is used to
  // reschedule the <cdevTimerHandler> automatically.  This method
  // returns a timer handle that uniquely identifies the
  // <cdevTimerhandler> in an internal list.  This timer handle can be
  // used to cancel an <cdevTimerhandler> before it expires.  The
  // cancellation ensures that timer_ids are unique up to values of
  // greater than 2 billion timers.  As long as timers don't stay
  // around longer than this there should be no problems with
  // accidentally deleting the wrong timer.
  
  int   cancel        (cdevTimerHandler* handler);
  // PURPOSE: cancel all timers associated with handler
  // REQUIRE: handler != 0
  // PROMISE: all timer is canceled. return 0

  int   cancel        (int id);
  // PURPOSE: cancel a single timer with id
  // REQUIRE: id must be valid
  // PROMISE: if id is found, the timer is canceled.

  int   expire        (const cdevTimeValue& current_time);
  // PURPOSE: run the <timerCallback> method for all timers whose values are
  //          <= current_time
  
private:
  void  reschedule    (cdevTimerQNode* node);
  // reschedule a "interval" timer

  cdevSlist   queue_;
  // real linked list as a queue

  int         timerId_;
  // run time timer id
};
#endif
  
		       

  
  

		  
		  
