//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevRequestObject Error Handler Object (User Cannot Access this)
//
// Author:  Jie Chen & Chip Watson
//
// Revision History:
//   cdevErrReqObject.h,v
// Revision 1.2  1998/03/09  18:51:37  chen
// redefine getState/getAccess for errReqObject
//
// Revision 1.1.1.1  1995/06/16  17:14:06  epics
// initial import of cdev
//
//
#ifndef _CDEV_ERR_REQOBJ_H
#define _CDEV_ERR_REQOBJ_H

#include <cdevRequestObject.h>

class cdevErrReqObject: public cdevRequestObject
{
 public:
  // destructor
  ~cdevErrReqObject (void);

  int send (cdevData& out, cdevData& result);
  int send (cdevData* out, cdevData& result); 
  int send (cdevData& out, cdevData* result); 
  int send (cdevData* out, cdevData* result); 

  int sendNoBlock (cdevData& out, cdevData& result);
  int sendNoBlock (cdevData* out, cdevData& result);
  int sendNoBlock (cdevData& out, cdevData* result);
  int sendNoBlock (cdevData* out, cdevData* result);

  int sendCallback (cdevData& out, cdevCallback& callback);
  int sendCallback (cdevData* out, cdevCallback& callback);

  int getState     (void);
  int getAccess    (void);

  const char *className (void) const {return "cdevErrReqObject";}

 private:
  // constructor
  cdevErrReqObject (cdevSystem& system = cdevSystem::defaultSystem());
  friend class cdevSystem;
};
#endif
