#include <IntHash.h>
#include <cdevMessage.h>

const size_t ArrayMessageCount = 1000;
cdevMessage  ArrayMessage[ArrayMessageCount];
char        *ArrayDeviceName   = "device1";
int          ArrayMessageIndex = 0;

void createArrayMessages ( void )
{
cdevData data;
cdevData context;

for(int i=0; i<ArrayMessageCount; i++)
	{
	data.addTag("packetNumber");
	data.insert("packetNumber", i);
	data.insert("value", i*18+0);
	data.insert("status", i*18+1);
	data.insert("time", i*18+2);
	data.insert("controlHigh", i*18+3);
	data.insert("controlLow", i*18+4);
	data.insert("alarmHigh", i*18+5);
	data.insert("alarmLow", i*18+6);
	data.insert("displayHigh", i*18+7);
	data.insert("displayLow", i*18+8);
	data.insert("resultCode", 0);
	
	context.insert("value", i*18+9);
	context.insert("status", i*18+10);
	context.insert("time", i*18+11);
	context.insert("controlHigh", i*18+12);
	context.insert("controlLow", i*18+13);
	context.insert("alarmHigh", i*18+14);
	context.insert("alarmLow", i*18+15);
	context.insert("displayHigh", i*18+16);
	context.insert("displayLow", i*18+17);

	ArrayMessage[i].setClientID   (1);
	ArrayMessage[i].setDeviceList (&ArrayDeviceName, 1, 1);
	ArrayMessage[i].setMessage    ("get attrib", 1);
	ArrayMessage[i].setData       (new cdevData(data));
	ArrayMessage[i].setContext    (new cdevData(context));
	}
}
