#include <cdevServer.h>
#include <StringHash.h>

class ByteDevice
{
public:
	ByteDevice ( size_t idx )
		{
		value  = idx+1;
		status = idx+1;
		};

	unsigned char value;
	int           status;
};


class ByteArrayDevice
{
public:
	ByteArrayDevice ( size_t idx, size_t cnt )
		: count(cnt)
		{
		value = new unsigned char[count];
		for(int i=0; i<count; i++)
			{
			value[i] = (idx+1)*10 + (i+1);
			}
		status = idx+1;
		};

	~ByteArrayDevice ( void )
		{
		delete[] value;
		}
		
	unsigned char  * value;
	int       status;
	size_t    count;
};


class ShortDevice
{
public:
	ShortDevice ( size_t idx )
		{
		value  = -1*(idx+1);
		status = idx+1;
		};

	short value;
	int   status;
};


class ShortArrayDevice
{
public:
	ShortArrayDevice ( size_t idx, size_t cnt )
		: count(cnt)
		{
		value = new short[count];
		for(int i=0; i<count; i++)
			{
			value[i] = -1*((idx+1)*100 + (i+1));
			}
		status = idx+1;
		};

	~ShortArrayDevice ( void )
		{
		delete[] value;
		}
		
	short  * value;
	int      status;
	size_t   count;
};

class UShortDevice
{
public:
	UShortDevice ( size_t idx )
		{
		value  = idx+1;
		status = idx+1;
		};

	unsigned short value;
	int   status;
};


class UShortArrayDevice
{
public:
	UShortArrayDevice ( size_t idx, size_t cnt )
		: count(cnt)
		{
		value = new unsigned short[count];
		for(int i=0; i<count; i++)
			{
			value[i] = (idx+1)*100 + (i+1);
			}
		status = idx+1;
		};

	~UShortArrayDevice ( void )
		{
		delete[] value;
		}
		
	unsigned short  * value;
	int               status;
	size_t            count;
};


class IntDevice
{
public:
	IntDevice ( size_t idx )
		{
		value  = -1*(idx+1);
		status = idx+1;
		};

	int    value;
	int    status;
};


class IntArrayDevice
{
public:
	IntArrayDevice ( size_t idx, size_t cnt )
		: count(cnt)
		{
		value = new int[count];
		for(int i=0; i<count; i++)
			{
			value[i] = -1*((idx+1)*1000 + (i+1));
			}
		status = idx+1;
		};

	~IntArrayDevice ( void )
		{
		delete[] value;
		}
		
	int  * value;
	int    status;
	size_t count;
};


class UIntDevice
{
public:
	UIntDevice ( size_t idx )
		{
		value  = idx+1;
		status = idx+1;
		};

	unsigned int value;
	int   status;
};


class UIntArrayDevice
{
public:
	UIntArrayDevice ( size_t idx, size_t cnt )
		: count(cnt)
		{
		value = new unsigned int[count];
		for(int i=0; i<count; i++)
			{
			value[i] = (idx+1)*100 + (i+1);
			}
		status = idx+1;
		};

	~UIntArrayDevice ( void )
		{
		delete[] value;
		}
		
	unsigned int  * value;
	int             status;
	size_t          count;
};


class FloatDevice
{
public:
	FloatDevice ( size_t idx )
		{
		value  = -1*(((float)idx+1.0) + (((float)idx)+1.0)/10.0);
		status = idx+1;
		};

	float    value;
	int      status;
};


class FloatArrayDevice
{
public:
	FloatArrayDevice ( size_t idx, size_t cnt )
		: count(cnt)
		{
		value = new float[count];
		for(int i=0; i<count; i++)
			{
			value[i] = -1*(((float)idx+1.0)*1000.0 + (((float)i)+1.0)/10.0);
			}
		status = idx+1;
		};

	~FloatArrayDevice ( void )
		{
		delete[] value;
		}
		
	float  * value;
	int      status;
	size_t   count;
};


class DoubleDevice
{
public:
	DoubleDevice ( size_t idx )
		{
		value  = ((double)idx+1.0) + (((double)idx)+1.0)/10.0;
		status = idx+1;
		};

	double    value;
	int       status;
};


class DoubleArrayDevice
{
public:
	DoubleArrayDevice ( size_t idx, size_t cnt )
		: count(cnt)
		{
		value = new double[count];
		for(int i=0; i<count; i++)
			{
			value[i] = ((double)idx+1.0)*1000.0 + (((double)i)+1.0)/10.0;
			}
		status = idx+1;
		};

	~DoubleArrayDevice ( void )
		{
		delete[] value;
		}
		
	double  * value;
	int       status;
	size_t    count;
};


class StringDevice
{
public:
	StringDevice ( size_t idx )
		{
		value  = new char[25];
		sprintf(value, "String Device %i", idx);
		status = idx;
		};

	char *    value;
	int       status;
};


class StringArrayDevice
{
public:
	StringArrayDevice ( size_t idx, size_t cnt )
		: count(cnt)
		{
		value = new char *[count];
		for(int i=0; i<count; i++)
			{
			value[i]  = new char[25];
			sprintf(value[i], "String Array Device %i - %i", idx, i);
			}
		status = idx;
		};
	~StringArrayDevice ( void )
		{
		while(count>0)
			{
			delete[] value[--count];
			}
		delete[] value;
		}
	char **   value;
	int       status;
	size_t    count;
};


class myServer : public cdevServer
{
private:
	StringHash devArrays;

public:
	myServer ( void )
		: cdevServer(), devArrays()
		{
		setupAttribs();
		}
		
	myServer ( char * domain, char * server, unsigned int port, double pulse )
		: cdevServer(domain, server, port, pulse), devArrays()
		{
		setupAttribs();
		}
	
	// *********************************************************************
	// * In this function we are going to establish a variety of attributes
	// * for each device.
	// * IntDevice: IntDevice1, IntDevice2, IntDevice3, IntDevice4
	// *********************************************************************    	
	void setupAttribs ( void )
		{
		char * deviceName = new char[20];
		int idx = 0;
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "ByteDevice%d", idx);
			devArrays.insert(deviceName, (void *)new ByteDevice(idx));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "ByteArrayDevice%d", idx);
			devArrays.insert(deviceName, (void *)new ByteArrayDevice(idx, (idx+1)*2));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "ShortDevice%d", idx);
			devArrays.insert(deviceName, (void *)new ShortDevice(idx));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "ShortArrayDevice%d", idx);
			devArrays.insert(deviceName, (void *)new ShortArrayDevice(idx, (idx+1)*2));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "UShortDevice%d", idx);
			devArrays.insert(deviceName, (void *)new UShortDevice(idx));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "UShortArrayDevice%d", idx);
			devArrays.insert(deviceName, (void *)new UShortArrayDevice(idx, (idx+1)*2));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "IntDevice%d", idx);
			devArrays.insert(deviceName, (void *)new IntDevice(idx));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "IntArrayDevice%d", idx);
			devArrays.insert(deviceName, (void *)new IntArrayDevice(idx, (idx+1)*2));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "UIntDevice%d", idx);
			devArrays.insert(deviceName, (void *)new UIntDevice(idx));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "UIntArrayDevice%d", idx);
			devArrays.insert(deviceName, (void *)new UIntArrayDevice(idx, (idx+1)*2));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "FloatDevice%d", idx);
			devArrays.insert(deviceName, (void *)new FloatDevice(idx));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "FloatArrayDevice%d", idx);
			devArrays.insert(deviceName, (void *)new FloatArrayDevice(idx, (idx+1)*2));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "DoubleDevice%d", idx);
			devArrays.insert(deviceName, (void *)new DoubleDevice(idx));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "DoubleArrayDevice%d", idx);
			devArrays.insert(deviceName, (void *)new DoubleArrayDevice(idx, (idx+1)*2));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "StringDevice%d", idx);
			devArrays.insert(deviceName, (void *)new StringDevice(idx));
			}
		for(idx=0; idx<4; idx++)
			{
			sprintf(deviceName, "StringArrayDevice%d", idx);
			devArrays.insert(deviceName, (void *)new StringArrayDevice(idx, (idx+1)*2));
			}
		}	
		
	virtual void processMessages ( void )
		{
		cdevMessage * message;
	
		while(dequeue(message)==0)
			{
			if(!strcmp(message->getMessage(), "register"))
				{
				printf("Starting Testing on Client %i\n", message->getClientID());
				}
			else if(!strcmp(message->getMessage(), "unregister"))
				{
				printf("Finishing Testing on Client %i\n", message->getClientID());
				}
			else	
				{
				char ** devices = message->getDeviceList();
				// printf("Received request %s %s\n", devices[0], message->getMessage());
				if(devices && devices[0])
					{
					if(strncmp(devices[0], "ByteArrayDevice", 15)==0)
						{
						ByteArrayDevice * dev = (ByteArrayDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value, dev->count);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "ByteDevice", 10)==0)
						{
						ByteDevice * dev = (ByteDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "ShortArrayDevice", 14)==0)
						{
						ShortArrayDevice * dev = (ShortArrayDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value, dev->count);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "ShortDevice", 9)==0)
						{
						ShortDevice * dev = (ShortDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "UShortArrayDevice", 14)==0)
						{
						UShortArrayDevice * dev = (UShortArrayDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value, dev->count);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "UShortDevice", 9)==0)
						{
						UShortDevice * dev = (UShortDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "IntArrayDevice", 14)==0)
						{
						IntArrayDevice * dev = (IntArrayDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value, dev->count);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "IntDevice", 9)==0)
						{
						IntDevice * dev = (IntDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "UIntArrayDevice", 14)==0)
						{
						UIntArrayDevice * dev = (UIntArrayDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value, dev->count);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "UIntDevice", 9)==0)
						{
						UIntDevice * dev = (UIntDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "FloatArrayDevice", 14)==0)
						{
						FloatArrayDevice * dev = (FloatArrayDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value, dev->count);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "FloatDevice", 9)==0)
						{
						FloatDevice * dev = (FloatDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "DoubleArrayDevice", 14)==0)
						{
						DoubleArrayDevice * dev = (DoubleArrayDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value, dev->count);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "DoubleDevice", 9)==0)
						{
						DoubleDevice * dev = (DoubleDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "StringArrayDevice", 17)==0)
						{
						StringArrayDevice * dev = (StringArrayDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value, dev->count);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else if(strncmp(devices[0], "StringDevice", 12)==0)
						{
						StringDevice * dev = (StringDevice *)devArrays.find(devices[0]);
					
						if(dev!=NULL)
							{
							message->setCompletionCode(CDEV_SUCCESS);
							message->setData(new cdevData);
							message->getData()->insert("value", dev->value);
							message->getData()->insert("status", dev->status);
							}
						else
							{
							message->setCompletionCode(CDEV_ERROR);
							printf("ERROR: Unknown device requested... %s\n", devices[0]);
							}
						}
					else
						{
						message->setCompletionCode(CDEV_ERROR);
						printf("ERROR: Unknown device requested... %s\n", devices[0]);
						}
					}
				else	{
					message->setCompletionCode(CDEV_ERROR);
					printf("ERROR: No device specified\n");
					}
				}
			enqueue(message);
			delete message;
			}
		}
};

int main(int argc, char ** argv)
{
char * name;
short port;

name = (argc>1)?argv[1]:(char *)"ArrayServer1";
port = 0;

cdevSystem::defaultSystem().setThreshold(CDEV_SEVERITY_INFO);
myServer *server = new myServer();
server->startServer("ARRAY", name, port, 60.0, 1);
cdevServer::runServer();
delete server;
return 0;
}
