#include <ctype.h>
#include <signal.h>

#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevCommon.h>
#include <testMessages.cc>

int      fouled       = 0;
int      expectedHits = 0;
int      hits         = 0;
unsigned totalCount   = 0;

void callback ( int status, void * arg, cdevRequestObject &, cdevData & data)
	{
	hits++;
	if(status!=CDEV_SUCCESS)
		{
		printf("ERROR: Transmission failure of %i\n", (int)arg);
		}
	else
		{
		if(data!=*ArrayMessage[(int)arg].getData())
			{
			fouled = 1;
			printf("ERROR: Mismatch on entry %i - Inbound data differs from expected\n", 
				(int)arg);
			printf("----------------------------- INBOUND DATA -----------------------------\n");
			data.asciiDump();
			printf("----------------------------- EXPECTED DATA ----------------------------\n");
			ArrayMessage[(int)arg].getData()->asciiDump(); 
			}
		else
			{
			totalCount++;
			if(totalCount%100==0)
				{
				printf("Transmission %i still matches correctly\n", totalCount);
				}
			}
		}
	}
	
	
int main(int argc, char ** argv)
{
createArrayMessages();
int maxCount        = 0;
int group1          = ArrayMessageCount/3;
int group2          = group1+group1;
int retryCnt        = 0;
int grpRetryCnt     = 0;
int dataIdx         = 0;

cdevRequestObject &tReq = cdevRequestObject::attachRef(ArrayMessage[ArrayMessageIndex].getDeviceList()[0], ArrayMessage[ArrayMessageIndex].getMessage());
tReq.setContext(*ArrayMessage[0].getContext());

if(argc>1) maxCount = atoi(argv[1]);

while(!fouled && (!maxCount ||  maxCount<totalCount))
	{
	hits         = 0;
	expectedHits = 0;

	for(ArrayMessageIndex = 0; ArrayMessageIndex<group1; ArrayMessageIndex++)
		{
		int                 mismatch = 0;
		cdevData            data;
		cdevRequestObject * req = cdevRequestObject::attachPtr(ArrayMessage[ArrayMessageIndex].getDeviceList()[0], ArrayMessage[ArrayMessageIndex].getMessage());
		req->setContext(*ArrayMessage[ArrayMessageIndex].getContext());

		if(req->send(ArrayMessage[ArrayMessageIndex].getData(), &data)==CDEV_SUCCESS)
			{
			if(data!=*ArrayMessage[ArrayMessageIndex].getData())
				{
				fouled = -1;
				printf("ERROR: Mismatch on entry %i - Inbound data differs from expected\n", 
					ArrayMessageIndex);
				printf("----------------------------- INBOUND DATA -----------------------------\n");
				data.asciiDump();
				printf("----------------------------- EXPECTED DATA ----------------------------\n");
				ArrayMessage[ArrayMessageIndex].getData()->asciiDump(); 
				}
			else
				{
				totalCount++;
				if(totalCount%100==0)
					{
					printf("Transmission %i still matches correctly\n", totalCount);
					}
				}
			}
		else 	{
			printf("ERROR: Transmission failure of %i\n",
				ArrayMessageIndex);
			}
		}

	for( ; ArrayMessageIndex<group2; ArrayMessageIndex++)
		{
		cdevCallback        cb(callback, (void *)ArrayMessageIndex); 	
		int                 mismatch = 0;
		cdevData            data;
		cdevRequestObject * req = cdevRequestObject::attachPtr(ArrayMessage[ArrayMessageIndex].getDeviceList()[0], ArrayMessage[ArrayMessageIndex].getMessage());
		req->setContext(*ArrayMessage[ArrayMessageIndex].getContext());

		if(req->sendCallback(ArrayMessage[ArrayMessageIndex].getData(), cb)!=CDEV_SUCCESS)
			{
			fouled = -1;
			printf("ERROR: Transmission failure of %i\n",
				ArrayMessageIndex);
			}
		else expectedHits++;
		}
	
	for(retryCnt=0; hits<expectedHits && retryCnt<1000; retryCnt++)
		{
		cdevSystem::defaultSystem().poll();
		}

	if(hits<expectedHits)
		{
		printf("ERROR: Processed only %i of %i callback requests after %i attempts\n", hits, expectedHits, retryCnt);
		}
			
	cdevData * outputData = new cdevData[ArrayMessageCount - (group2)];
	cdevGroup  group;
	
	group.start();
	for(dataIdx=0; ArrayMessageIndex<ArrayMessageCount; ArrayMessageIndex++, dataIdx++)
		{
		int                 mismatch = 0;
		cdevData            data;
		cdevRequestObject * req = cdevRequestObject::attachPtr(ArrayMessage[ArrayMessageIndex].getDeviceList()[0], ArrayMessage[ArrayMessageIndex].getMessage());
		req->setContext(*ArrayMessage[ArrayMessageIndex].getContext());

		if(req->sendNoBlock(ArrayMessage[ArrayMessageIndex].getData(), outputData[dataIdx])!=CDEV_SUCCESS)
			{
			fouled = -1;
			printf("ERROR: Transmission failure of %i\n",
				ArrayMessageIndex);
			}
		}
	group.end();
	
	for(grpRetryCnt=0; !group.allFinished() && grpRetryCnt<1000; grpRetryCnt++)
		{
		group.poll();
		}
		
	if(!group.allFinished())
		{
		printf("ERROR: Failed to process all group requests after %i attempts\n", grpRetryCnt);
		}
		
	for(dataIdx=0, ArrayMessageIndex=group2; ArrayMessageIndex<ArrayMessageCount; ArrayMessageIndex++, dataIdx++)
		{
		if(outputData[dataIdx]!=*ArrayMessage[ArrayMessageIndex].getData())
			{
			fouled = -1;
			printf("ERROR: Mismatch on entry %i - Inbound data differs from expected\n", 
				ArrayMessageIndex);
			printf("----------------------------- INBOUND DATA -----------------------------\n");
			outputData[dataIdx].asciiDump();
			printf("----------------------------- EXPECTED DATA ----------------------------\n");
			ArrayMessage[ArrayMessageIndex].getData()->asciiDump(); 
			}
		else 
			{
			totalCount++;
			if(totalCount%100==0)
				{
				printf("Transmission %i still matches correctly\n", totalCount);
				}
			}
		}	
	delete [] outputData;
	}
return 1;
}
