#include <ctype.h>
#include <signal.h>

#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevCommon.h>
	
int main(int argc, char ** argv)
{
char * descriptions [17] = 
	{
	"Ascii Dump of Scalar Byte Collection",
	"Ascii Dump of Scalar Int Collection",
	"Ascii Dump of Scalar Unsigned Int Collection",
	"Ascii Dump of Scalar Short Collection",
	"Ascii Dump of Scalar Unsigned Short Collection",
	"Ascii Dump of Scalar Double Collection",
	"Ascii Dump of Scalar Float Collection",
	"Ascii Dump of Scalar String Collection",
	"Ascii Dump of Byte Array Collection",
	"Ascii Dump of Int Array Collection",
	"Ascii Dump of Unsigned Int Array Collection",
	"Ascii Dump of Short Array Collection",
	"Ascii Dump of Unsigned Short Array Collection",
	"Ascii Dump of Double Array Collection",
	"Ascii Dump of Float Array Collection",
	"Ascii Dump of String Array Collection",
	"Ascii Dump of Mixed Collection"
	};
cdevRequestObject * req[17] = 
	{
	cdevRequestObject::attachPtr("ByteCollection",   "get value"),
	cdevRequestObject::attachPtr("IntCollection",    "get value"),
	cdevRequestObject::attachPtr("UIntCollection",   "get value"),
	cdevRequestObject::attachPtr("ShortCollection",  "get value"),
	cdevRequestObject::attachPtr("UShortCollection", "get value"),
	cdevRequestObject::attachPtr("DoubleCollection", "get value"),
	cdevRequestObject::attachPtr("FloatCollection",  "get value"),
	cdevRequestObject::attachPtr("StringCollection", "get value"),
	cdevRequestObject::attachPtr("ByteArrayCollection",   "get value"),
	cdevRequestObject::attachPtr("IntArrayCollection",    "get value"),
	cdevRequestObject::attachPtr("UIntArrayCollection",   "get value"),
	cdevRequestObject::attachPtr("ShortArrayCollection",  "get value"),
	cdevRequestObject::attachPtr("UShortArrayCollection", "get value"),
	cdevRequestObject::attachPtr("DoubleArrayCollection", "get value"),
	cdevRequestObject::attachPtr("FloatArrayCollection",  "get value"),
	cdevRequestObject::attachPtr("StringArrayCollection", "get value"),
	cdevRequestObject::attachPtr("CompCollection",   "get value")
	};

cdevData result[17];

while(1)
	{
	int i;
	for(int j=0; j<60; j++)
		{
		if(j%5==0)
			{
			printf(".");
			fflush(stdout);
			}
		for(i=0; i<17; i++)
			{
			if(req[i]) req[i]->send(NULL, result[i]);
			}
		}
	for(i=0; i<17; i++)
		{
		printf("%s\n-------------------------------------------------\n", descriptions[i]);
		result[i].asciiDump();
		}
	}
}
