#include <PerformanceService.h>

// *****************************************************************************
// * newPerformanceService:
// *	This function will be called by the cdevSystem object to create an 
// *	initial instance of the PerformanceService.
// *****************************************************************************
extern "C" cdevService * newPerformanceService (char * name, cdevSystem * system)
	{
	return new PerformanceService(name, *system);
	}

// *****************************************************************************
// * PerformanceService::PerformanceService :
// *	This is teh constructor for the PerformanceService.  It initializes the
// *	underlying cdevClientService by specifying that it is in the domain of
// *	PERFORMANCE.
// *****************************************************************************
PerformanceService::PerformanceService ( char * name, cdevSystem & system)
	: cdevClientService("PERFORMANCE", name, system) 
	{
	system.reportError(CDEV_SEVERITY_INFO, "PerformanceService", NULL, 
			   "Constructing a new PerformanceService"); 
	}

PerformanceService::~PerformanceService ( void )
	{
	}
