#include <cdevServer.h>


// *****************************************************************************
// * class PerformanceServer :
// *	This is a performance test server.  It simply receives messages
// *	from a client and immediately returns them.
// *
// *	The constructor passes the domain, server, port and rate to the
// *	underlying cdevServer class to be processed.  The cdevServer constructor
// *	will add this server to the Name Server and will begin processing 
// *	messages when the cdevServer::runServer() method is executed.
// *
// *	The processMessages method is the servers interface to the world... Each
// *	time a complete message is received or the time specified in rate
// *	expires, that method will be called.
// *****************************************************************************
class PerformanceServer : public cdevServer
{
cdevMessage * pmMessage;

public:
	PerformanceServer ( char * domain, char * server, unsigned int port, double pulse )
		: cdevServer(domain, server, port, pulse)
		{
		}

	virtual void processMessages ( void )
		{
		while(dequeue(pmMessage)==0)
			{
			enqueue(pmMessage);
			delete pmMessage;
			}
		}
		
};


int main(int argc, char ** argv)
{
char * serverName;

if(argc>1) serverName = argv[1];
else serverName = strdup("Performance1");	

PerformanceServer server("PERFORMANCE", serverName, 0, 5);
cdevServer::runServer();

return 0;
}
