#include <cdevPlatforms.h>
#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevCommon.h>

int callbackCount = 0;

const int DEVICE_COUNT  = 9;
const int MESSAGE_COUNT = 9;

int main ( )
	{
	fprintf(stdout, "\n\
=> **********************************************************************\n\
=> * This is the writing side of a two part monitoring test program.    *\n\
=> * This program will set up a list of devices and attributes and      *\n\
=> * will modify them at a regular rate.                                *\n\
=> **********************************************************************\n\n");
	fflush(stdout);
	cdevDevice * deviceList[DEVICE_COUNT];
	cdevRequestObject * reqList[DEVICE_COUNT*MESSAGE_COUNT];
	cdevData     data;
	float        values[DEVICE_COUNT*MESSAGE_COUNT];
	char         msg[255];
	int          deviceCnt;
	int          msgCnt;
	
	// *********************************************************************
	// * First get all of the values from the devices.
	// *********************************************************************
	for(deviceCnt=0; deviceCnt<DEVICE_COUNT; deviceCnt++)
		{
		sprintf(msg, "device%i", deviceCnt);
		deviceList[deviceCnt] = cdevDevice::attachPtr(msg);
		
		for(msgCnt=0; msgCnt<MESSAGE_COUNT; msgCnt++)
			{
			sprintf(msg, "get attrib%i", msgCnt);
			if(deviceList[deviceCnt]->send(msg, NULL, data)==CDEV_SUCCESS)
				{
				data.get("value", &values[deviceCnt*MESSAGE_COUNT+msgCnt]);
				}
			else	{
				values[deviceCnt*MESSAGE_COUNT+msgCnt] = 0;
				fprintf(stdout, "ERROR : device %s : %s failed\n", deviceList[deviceCnt]->name(), msg);
				}
			sprintf(msg, "set attrib%i", msgCnt);
			reqList[deviceCnt*MESSAGE_COUNT+msgCnt] = deviceList[deviceCnt]->getRequestObject(msg);
			}		
		}
	
	while(1)
		{
		for(int i=0; i<DEVICE_COUNT*MESSAGE_COUNT; i++)
			{
			values[i]+=1.0;
			data.insert("value", values[i]);
			reqList[i]->sendNoBlock(data, NULL);
			}
		cdevSystem::defaultSystem().pend();
		}
	return 0;
	}
