#include <MonitorTestServer.h>
#include <MonitorTestAttrib.h>

// *****************************************************************************
// * This has to be added in order to support the CenterLine Compiler.
// *****************************************************************************
#if defined (__CENTERLINE__)
	long va_alist;
#endif

MonitorTestServer::~MonitorTestServer ( void )
	{
	StringHashIterator iter(&attribHash);
	MonitorTestAttrib    * attrib = NULL;	
	char             * key    = NULL;
	
	iter.first();
	while((key=iter.key())!=NULL)
		{
		attrib = (MonitorTestAttrib *)iter.data();
		iter++;
		attribHash.remove(key);
		if(attrib!=NULL) delete attrib;
		}
	}

void MonitorTestServer::populateTable ( void )
	{
	char device[10];
	char attrib[10];
	char key[20];
	for(int i=0; i<10; i++)
		{
		for(int j=0; j<10; j++)
			{
			sprintf(device, "device%i", i);
			sprintf(attrib, "attrib%i", j);
			sprintf(key, "device%i attrib%i", i, j);
			attribHash.insert(key, new MonitorTestAttrib(device, attrib));
			}
		}
	}

void MonitorTestServer::processMessages ( void )
	{
	char            key[255];
	int             saveMessageFlag;
	int             sendMessageFlag;
	cdevMessage   * message;
	MonitorTestAttrib * attrib;
	cdevData        output;

	while(dequeue(message)==0)
		{
		// *************************************************************
		// * Note at this point a cdevTagMap has already been received
		// * from the client.  This tag map will have initialized all
		// * of the tags that are required by the service.
		// *************************************************************
		if(!strcmp(message->getMessage(), "unregister"))
			{
			sendMessageFlag = 0;
			removeClientMonitors(message->getClientID());
			}
		if(!strncmp(message->getMessage(), "get ", 4))
			{
			output.remove();
			saveMessageFlag = 0;
			sendMessageFlag = 1;

			sprintf(key, "%s %s", 
			        message->getDeviceList()[0], 
			        &message->getMessage()[4]);
			
			if((attrib = (MonitorTestAttrib *)attribHash.find(key))!=NULL)
				{
				attrib->getToData(&output, message->getContext());
				output.insert("resultCode", CDEV_SUCCESS);
				}
			else output.insert("resultCode", CDEV_NOTFOUND);
			}
		else if(!strncmp(message->getMessage(), "set ", 4))
			{
			output.remove();
			saveMessageFlag = 0;
			sendMessageFlag = 1;
		
			sprintf(key, "%s %s", 
			        message->getDeviceList()[0], 
			        &message->getMessage()[4]);
			
			if((attrib = (MonitorTestAttrib *)attribHash.find(key))!=NULL)
				{
				output.insert("resultCode", 
					      attrib->setFromData(message->getData()));
				}
			else output.insert("resultCode", CDEV_NOTFOUND);
			}
		else if(!strncmp(message->getMessage(), "monitorOn ", 10))
			{
			saveMessageFlag = 1;
			sendMessageFlag = 0;
			
			sprintf(key, "%s %s", 
			        message->getDeviceList()[0], 
			        &message->getMessage()[10]);
			
			if((attrib = (MonitorTestAttrib *)attribHash.find(key))!=NULL)
				{
				attrib->insertMonitor(this, message);
				}
			}
		else if(!strncmp(message->getMessage(), "monitorOff ", 11))
			{
			saveMessageFlag = 0;
			sendMessageFlag = 1;

			sprintf(key, "%s %s", 
			        message->getDeviceList()[0], 
			        &message->getMessage()[11]);
			
			if((attrib = (MonitorTestAttrib *)attribHash.find(key))!=NULL)
				{
				attrib->removeMonitor(this, message);
				}
			}
		else
			{
			saveMessageFlag = 0;
			sendMessageFlag = 1;
			output.insert("resultCode", CDEV_NOTFOUND);
			}
			
		if(sendMessageFlag)
			{
			message->setData(&output, 1);
			enqueue(message);
			}
		if(!saveMessageFlag) delete message;
		}
	}

int MonitorTestServer::fireCallback ( cdevMessage * message ) 
	{
	int        result = CDEV_SUCCESS;
	cdevData * data   = NULL;
	
	if(message && (data = message->getData())!=NULL)
		{
		data->insert("resultCode", CDEV_SUCCESS);
		result = enqueue(message);
		}
	return result;
	}

int main(int argc, char ** argv)
{
fprintf(stdout, "\n\
=> **********************************************************************\n\
=> * This is a test server that is used to test the Monitoring          *\n\
=> * capabilities of the cdevGenericServer engine.  This server will be *\n\
=> * contacted with a list of monitor requests to which it will respond *\n\
=> **********************************************************************\n\n");
fflush(stdout);

char * name = "MonitorTestServer";

if(argc>1) name = argv[1];

MonitorTestServer server("MONITOR_TEST", name, 0, 60);
cdevServer::runServer();

return 0;
}
