#include <time.h>
#include <unistd.h>
#include <ctype.h>
#include <signal.h>

#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevCommon.h>

void callback ( int status, void * arg, cdevRequestObject & req, cdevData & data )
	{
	}
	
const int DEVICE_COUNT  = 9;
const int MESSAGE_COUNT = 9;

int main ( int argc, char ** argv )
	{
	cdevDevice * deviceList[DEVICE_COUNT];
	cdevRequestObject * reqList[DEVICE_COUNT*MESSAGE_COUNT];
	cdevCallback cb(callback, NULL);
	cdevData     data;
	float        values[DEVICE_COUNT][MESSAGE_COUNT];
	char         msg[255];
	int          deviceCnt;
	int          msgCnt;
	
	// *********************************************************************
	// * First get all of the values from the devices and install monitors.
	// *********************************************************************
	for(deviceCnt=0; deviceCnt<DEVICE_COUNT; deviceCnt++)
		{
		sprintf(msg, "device%i", deviceCnt);
		deviceList[deviceCnt] = cdevDevice::attachPtr(str);
		
		for(msgCnt=0; msgCnt<MESSAGE_COUNT; msgCnt++)
			{
			sprintf(msg, "get attrib%i", msgCnt);
			if(deviceList[deviceCnt]->send(msg, NULL, data)==CDEV_SUCCESS)
				{
				data->get("value", &values[deviceCnt][msgCnt]);
				}
			else values[deviceCnt][msgCnt] = 0;
			
			sprintf(msg, "monitorOn attrib%i", msgCnt);
			deviceList[deviceCnt]->sendCallback(msg, cb, NULL);
			
			sprintf(msg, "set attrib%i", msgCnt);
			reqList[deviceCnt*MESSAGE_COUNT+msgCnt] = deviceList[deviceCount]->getRequestObject(msg);
			}		
		}
	
	// *********************************************************************
	// * Finally, remove all monitors.
	// *********************************************************************
	for(deviceCnt=0; deviceCnt<DEVICE_COUNT; deviceCnt++)
		{
		for(msgCnt=0; msgCnt<MESSAGE_COUNT; msgCnt++)
			{
			sprintf(msg, "monitorOff attrib%i", msgCnt);
			deviceList[deviceCnt]->sendCallback(msg, cb, NULL);
			}
		}
	cdevSystem::defaultSystem().pend();
	}
