//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Server Streamed Message
//
//      This class allows either partial read/write not both
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_STREAM_MSG_H
#define _RSVC_STREAM_MSG_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

class rsvcNetData;

class rsvcStreamMsg
{
public:
  // constructor
  
  // create an empty stream
  rsvcStreamMsg (void);

  // create a stream with data buffer and size and flag denoting
  // whether we delete this data buffer we we are done
  rsvcStreamMsg (char* data, size_t size, int deleteit = 1);

  // create a stream from rsvcNetData
  rsvcStreamMsg (rsvcNetData* data);

  // destructor
  ~rsvcStreamMsg (void);

  // attach buffer
  void attach  (char* data, size_t size, int deleteit = 1);

  // check we are in the middle of action
  int  active  (void) const;

  // set action pointer
  void actionPtr (char* ptr);
  // move ptr forward
  void actionPtr (size_t n);
  // return action pointer
  char* actionPtr (void) const;

  // total message size
  size_t length  (void) const;

  // set msg length
  void   length  (size_t len);

  // base pointer
  char*  base    (void) const;

  // remaining message size (or space)
  size_t size    (void);
  // check whether we have reached end of message buffer
  int    endMsg  (void);

  // reset everything
  void   reset   (void);

  // resize buffer to twice of current size
  void   resize  (void);

private:

  // data area
  char*    buffer_;
  size_t   buflen_;

  // pointer to current action ptr
  size_t   cursor_;

  // flag denoting whether we are deleting the buffer or not
  int      deleteBuffer_;

  // flag to denoting whether this stream is in the middle of read/write
  int      active_;

  // deny copy and assignment operations
  rsvcStreamMsg (const rsvcStreamMsg& msg);
  rsvcStreamMsg& operator = (const rsvcStreamMsg& msg);
};
#endif
