//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Configuration Class
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_SERVER_CONFIG_H
#define _RSVC_SERVER_CONFIG_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcConfig.h>

#define RSVC_DBASE_HOME "/tmp/"
#define RSVC_SERVER_ENV "RSVC_SERVER_CONFIG"

class rsvcServerConfig
{
public:
  static int            configure         (char* filename = 0);
  // this is the port all servers to connected to (udp)
  static unsigned short serverPort        (void);
  // this is the port all client program to connect to
  static unsigned short port              (void);
  static size_t         dbasePageSize     (void);
  static size_t         dbaseCacheSize    (void);
  static size_t         dbaseCacheMax     (void);
  static size_t         dbaseCacheLf      (void);
  static size_t         maxNoFiles        (void);
  static char*          key               (void);
  static char*          table             (void);
  static char*          keyType           (void);
  static char*          keyExp            (void);
  static char*          dbaseHome         (void);
  static char*          tableNameExt      (void);
  static char*          monitorTag        (void);
  static char*          queryTag          (void);
  static char**         defaultDbases     (void);

protected:
  static unsigned short        port_;
  static size_t                pageSize_;
  static size_t                cacheSize_;
  static size_t                cacheMax_;
  static size_t                cacheLf_;
  static size_t                maxnofiles_;
  static char*                 keyName_;
  static char*                 keyType_;
  static char*                 keyExp_;
  static char*                 tableName_;
  static char*                 dbaseHome_; 
  static char*                 tableNameExt_;
  static char*                 monitorTag_;
  static char*                 queryTag_;
  static char**                defaultDbases_;
};
#endif
