//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Database Environment Class 
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_DATABASE_ENV_H
#define _RSVC_DATABASE_ENV_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <db.h>

class rsvcDatabaseEnv
{
public:
  // destructor
  ~rsvcDatabaseEnv (void);

  // static access to pointer of this object
  static rsvcDatabaseEnv* dbaseEnv (void);
  
  DB_ENV* dbenv    (void) const;

  // close all database actions, This is last one to call
  static  void close (void);

protected:
  // constructor
  rsvcDatabaseEnv  (void);
  
private:
  // single database environment
  static rsvcDatabaseEnv* env_;
  // real database stuff
  DB_ENV*              dbenv_;
};
#endif
