//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Server In Memory Data Store
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_DATASTORE_MEM_H
#define _RSVC_DATASTORE_MEM_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcErr.h>
#include <rsvcDataStore.h>

class rsvcCacheData;

class rsvcDataStoreMem: public rsvcDataStore
{
public:
  // constructor and destructor
  rsvcDataStoreMem  (char* name);
  ~rsvcDataStoreMem (void);

  // inherited operations
  // get data values
  // specified by a key
  virtual int getValue        (rsvcNetData& incoming,
			       rsvcNetData* outdata[], size_t* num);

  // insert a rsvcData which may have a key inside or not
  virtual int putValue        (rsvcNetData& incoming,
			       rsvcNetData* outdata[], size_t* num,
			       int overwrite = 0);

  // delete a data object pointed by key value
  virtual int delValue        (rsvcNetData& incoming,
			       rsvcNetData* outdata[], size_t* num);
  // flush all internal buffer to disk
  virtual int flush           (void);

  // set data value
  // specified either by a key or a whole data
  virtual int setValue        (rsvcNetData& incoming,
			       rsvcNetData* outdata[], size_t* num);

  // monitor on incoming database entries
  virtual int monitorIncomingEntries (rsvcNetData& incoming,
				      rsvcNetData* outdata[], size_t* num);

  // monitor off the above incoming database entries
  virtual int monitorOffIncomingEntries (rsvcNetData& incoming,
					 rsvcNetData* outdata[], size_t* num);

  // monitor on data values
  // monitor on either the whole data
  virtual int monitorValue    (rsvcNetData& incoming,
			       rsvcNetData* outdata[], size_t* num);

  // monitor on attribute of a data
  virtual int monitorAttr     (rsvcNetData& incoming,
			       rsvcNetData* outdata[], size_t* num);

  // monitor off data value
  virtual int monitorOffValue  (rsvcNetData& incoming,
				rsvcNetData* outdata[], size_t* num);

  // monitor off attribute of a data
  virtual int monitorOffAttr  (rsvcNetData& incoming,
			       rsvcNetData* outdata[], size_t* num);


  // monitor off data value for all monitors from same socket id
  virtual int monitorOff       (void* io);

  // query the data store
  virtual int query           (rsvcNetData& data, char* msg, 
			       rsvcNetData* outdata[], size_t* num);

  // get every entry in the store
  virtual int getAll          (rsvcNetData& incoming,
			       rsvcNetData* outdata[], size_t* num);


protected:

  // find cached data item inside cache from a key data
  rsvcCacheData* cachedData    (rsvcData& keydata);
  
  // delete a cached data item inside cache from a key dta
  int            deleteCachedData (rsvcData& key);
};
#endif

  
