//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Callback Class for Client
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_CALLBACK_H
#define _RSVC_CALLBACK_H

#include <stdio.h>
#include <string.h>
#include <rsvcData.h>

typedef void (*rsvcCbkFunc) (int status, void* arg, rsvcData* data);

class RSVC_CLASS_SPEC rsvcCallback
{
public:
  // constructor
  rsvcCallback                     (void);
  rsvcCallback                     (rsvcCbkFunc func, void* arg);
  rsvcCallback                     (const rsvcCallback& cbk);
  rsvcCallback& operator =         (const rsvcCallback& cbk);
  // destructor
  ~rsvcCallback                    (void);

  int operator ==                  (const rsvcCallback& cbk);
  int operator !=                  (const rsvcCallback& cbk);

  virtual rsvcCbkFunc cbkFunc      (void) const;
  virtual void*       userarg      (void) const;

  // return whether this callback is empty
  int                 empty        (void);

private:
  rsvcCbkFunc                      cbk_;
  void*                            arg_;
};
#endif
