//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Server Cached Data Class
//
//      This Class models the data objects that are stored inside
//      cache information of a database
//
//      Data always stored with key value
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_CACHE_DATA
#define _RSVC_CACHE_DATA

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <rsvcHashable.h>
#include <rsvcHash.h>
#include <rsvcData.h>
#include <rsvcNetData.h>

class rsvcVirtualDbase;
class rsvcTableDef;
class rsvcCacheDataAttr;

class rsvcCacheData : public rsvcHashable
{
public:
  // constructor

  // construct a cache data with a rsvcData which is transmitted
  // over from network or database with key tag specified
  rsvcCacheData  (rsvcData& data, rsvcVirtualDbase* dbase,
		  rsvcTableDef* table);

  // destructor
  virtual ~rsvcCacheData (void);

  // return hash code : inherited operation from rsvcHashable
  unsigned int hash (void);

  // monitor on/off methods for the whole data
  virtual int monitorOn    (rsvcCbk& cbk);
  virtual int monitorOff   (rsvcCbk& cbk);

  // monitor on/off a single attribute
  virtual int monitorAttr    (char* attr, rsvcCbk& cbk);
  virtual int monitorOffAttr (char* attr, rsvcCbk& cbk);

  // remove monitor specified by a io ptr
  virtual int monitorOff   (void* ioptr);

  // remove all monitors and attributes
  void  removeAllMonitors  (void);

  // remove all attributes
  void  removeAllAttrs     (void);

  // create all attributes
  void  createAllAttrs     (void);

  // check whether this data or any attributes are being monitored
  int          monitored       (void);

  // assignment or update method
  int          assign          (rsvcData& value);

  // in case of any change in value. send new value to all interested
  // parties
  virtual  void   notifyChannels (int status = RSVC_SUCCESS);

  // notify channels with a particular attribute name
  virtual  void   notifyChannels (const char* attr);

  // retrieve internal data
  rsvcData&     data           (void);

  // return attribute data
  rsvcCacheDataAttr*     attribute      (const char* attr);

  // check whether data has the same key value as data 'key'
  int     sameKey       (rsvcCacheData* key);
  
protected:

  // notify a single channel denoted by a cbk pointer
  virtual  void   notifySingleChannel (rsvcCbk* cbk);

  // real data
  rsvcData data_;

  // all monitor callback list: callback pointers
  rsvcHash monitorTable_;

  // all data for attributes
  rsvcHash  attributes_;

  // assocaited database
  rsvcVirtualDbase* database_;

  // assocaited table definition
  rsvcTableDef*     table_;

  // friend class
  friend class rsvcCacheDataAttr;
  

  // deny copy and assignment operations
  rsvcCacheData (const rsvcCacheData& data);
  rsvcCacheData& operator = (const rsvcCacheData& data);
};
#endif


  
