#ifndef _CDEV_ADDR_H_
#define _CDEV_ADDR_H_

#include "cdevPlatforms.h"

class CDEV_REACTOR_API cdevAddr 
{
protected:
	int addr_type;
	int addr_size;

public:
	cdevAddr     ( void ) : addr_type(0), addr_size(0) {}
	cdevAddr     ( int type, int size ) : addr_type(type), addr_size(size) {}
	int  getSize ( void )    const  { return addr_size; }
	void setSize ( int size )       { addr_size = size; }
	int  getType ( void )    const  { return addr_type; }
	void setType ( int type )       { addr_type = type; }

	virtual void * getAddress ( void ) const { return NULL; }

};


class CDEV_REACTOR_API cdevInetAddr : public cdevAddr
{
protected:
	sockaddr_in inet_addr;
	
public:
	cdevInetAddr (void);
	cdevInetAddr (const cdevInetAddr & addr);
	cdevInetAddr (const sockaddr_in *, int len);
	cdevInetAddr (unsigned short portnum, char hostname[]);
	cdevInetAddr (unsigned short portnum, long ip_addr=INADDR_ANY);
	
	int set (unsigned short portnum, const char hostname[]);
	int set (unsigned short portnum, long ip_addr=INADDR_ANY);
	int set (const sockaddr_in *, int len);
	
	const char *   getHostName ( void ) const;
	const char *   getHostAddr ( void ) const;
	unsigned long  getInetAddr ( void ) const;
	unsigned short getPortNum  ( void ) const;		
	void *         getAddress  ( void ) const;
};

#endif
